/*
 * Decompiled with CFR 0.152.
 */
package HitLom;

import HitServer.ServerLomCoder;
import HitUpros.HitException;
import HitUpros.HitSimpleDTS;
import HitUpros.LomCoder2;
import HitUpros.LomCoderErrors;
import HitUpros.LomDate;
import HitUpros.LomNumber;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Date;
import java.util.Properties;

public class AppletTestUI
extends Applet {
    private static final long serialVersionUID = -4551332635244618251L;
    private static final String sstrThisAppletVersion = "HitLom Applet Version 19 (10-Jul-2013)";
    private boolean boolThisIsRunningAsApplet = true;
    Label objLabelLom = new Label();
    Label objLabelDatum = new Label();
    TextField objTextFieldLom = new TextField();
    TextField objTextFieldDatum = new TextField();
    Button objButtonCodiere = new Button();
    TextArea objTextAreaStatus = new TextArea("", 0, 0, 1);

    public static void main(String[] stringArray) {
        Frame frame = new Frame("TestUI f\u00fcr Alpha-LOM");
        AppletTestUI appletTestUI = new AppletTestUI();
        frame.add((Component)appletTestUI, "Center");
        AppletTestUI appletTestUI2 = appletTestUI;
        appletTestUI2.getClass();
        frame.addWindowListener(appletTestUI2.new QuitHandler());
        frame.setBounds(400, 400, 320, 200);
        frame.setResizable(false);
        frame.setVisible(true);
        appletTestUI.init();
        appletTestUI.boolThisIsRunningAsApplet = false;
        appletTestUI.start();
    }

    @Override
    public void init() {
        this.setLayout(null);
        this.setBackground(Color.lightGray);
        this.objLabelLom.setText("AlphaLOM");
        this.add(this.objLabelLom);
        this.objLabelLom.setBounds(20, 20, 60, 20);
        this.add(this.objTextFieldLom);
        this.objTextFieldLom.setBounds(80, 20, 144, 20);
        this.objLabelDatum.setText("Datum");
        this.objLabelDatum.setForeground(Color.blue);
        this.add(this.objLabelDatum);
        this.objLabelDatum.setBounds(20, 50, 60, 20);
        this.add(this.objTextFieldDatum);
        this.objTextFieldDatum.setBounds(80, 50, 144, 20);
        this.objButtonCodiere.setLabel("Umwandeln");
        this.add(this.objButtonCodiere);
        this.objButtonCodiere.setBounds(225, 20, 75, 20);
        this.objTextAreaStatus.setEditable(false);
        this.add(this.objTextAreaStatus);
        this.objTextAreaStatus.setBounds(20, 80, 280, 80);
        TextFieldLomHandler textFieldLomHandler = new TextFieldLomHandler();
        this.objTextFieldLom.addKeyListener(textFieldLomHandler);
        TextFieldDatumHandler textFieldDatumHandler = new TextFieldDatumHandler();
        this.objTextFieldDatum.addKeyListener(textFieldDatumHandler);
        ButtonHandler buttonHandler = new ButtonHandler();
        this.objButtonCodiere.addActionListener(buttonHandler);
    }

    private void encodeLom() throws HitException {
        String string;
        this.objTextAreaStatus.setText("");
        String string2 = this.objTextFieldLom.getText().toUpperCase();
        if (string2.trim().length() == 0) {
            this.objTextAreaStatus.setText("Im Feld AlphaLOM etwas eingeben!");
            return;
        }
        if (string2.startsWith("$VER")) {
            this.objTextAreaStatus.setText("LomCoder Version 42 (10-Jul-2013)\nHitLom Applet Version 19 (10-Jul-2013)");
            return;
        }
        if (string2.startsWith("$CLASSPATH")) {
            try {
                Properties properties = System.getProperties();
                this.objTextAreaStatus.setText(properties.getProperty("java.class.path", "<kein Classpath gesetzt!>"));
            }
            catch (SecurityException securityException) {
                this.objTextAreaStatus.setText("Sie haben keine Berechtigung, den Classpath Ihres Browsers auszulesen.\nBesitzer des Internet Explorers m\u00fcssen dazu in den Internetoptionen bei Sicherheit/Internetzone bzw. Sicherheit/Lokale Intranetzone die benutzerdefinierten Einstellungen zu Java so \u00e4ndern, indem Sie das Auslesen der Systemumgebung aktivieren.\n\nNetscape-/Firefox-Nutzer haben hier keine M\u00f6glichkeit, Systemeinstellungen \u00fcber Applets einzulesen.");
            }
            return;
        }
        if (string2.startsWith("$LAND=")) {
            String string3 = string2.substring(6);
            int n = -1;
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n >= 0) {
                string3 = LomCoder2.sstrCodeToAlpha(n);
            } else {
                n = LomCoder2.sintAlphaToCode(string3);
            }
            if (n < 0 || string3.equals("")) {
                this.objTextAreaStatus.setText("Der L\u00e4ndercode besteht immer aus zwei Buchstaben oder aus 2 bzw. 3 Ziffern, d.h. die Eingabe m\u00fc\u00dfte\n   $LAND=DE\noder\n   $LAND=276\nhei\u00dfen oder Ihr angegebenes Land ist unbekannt!");
                return;
            }
            String string4 = "000" + n;
            string4 = string4.substring(string4.length() - 3);
            this.objTextAreaStatus.setText("Land " + string3 + " = ISO " + string4);
            return;
        }
        if (string2.startsWith("$QUIT")) {
            if (this.boolThisIsRunningAsApplet) {
                this.destroy();
            } else {
                System.exit(0);
            }
            return;
        }
        if (string2.startsWith("$")) {
            this.objTextAreaStatus.setText("Eine LOM beginnt nicht mit $.");
            return;
        }
        String string5 = this.objTextFieldDatum.getText();
        Date date = LomDate.NOT_SET;
        try {
            int n = string5.length();
            if (n >= 8 && n <= 10) {
                date = HitSimpleDTS.sobjStrToSqlDate(string5);
            } else if (n > 0) {
                throw new HitException((String)null);
            }
        }
        catch (HitException hitException) {
            this.objTextAreaStatus.setText("Datumsangabe fehlerhaft: DD.MM.JJJJ");
            return;
        }
        LomNumber lomNumber = new LomNumber();
        int n = ServerLomCoder.sintEncodeLom(string2, lomNumber, date);
        int n2 = LomCoderErrors.sintGetFehlerSchwere(n);
        String string6 = ServerLomCoder.sstrDecodeLom(lomNumber);
        if (n2 < 2 && string6.charAt(0) == '#') {
            n2 = 3;
        }
        if (n2 < 2) {
            string = "LOM: " + ServerLomCoder.sstrToString(lomNumber) + "\nbzw. " + string6;
            if (n2 == 1) {
                string = string + "\nHinweis: " + LomCoderErrors.sstrGetError(n);
            }
        } else {
            string = "Die LOM ist ung\u00fcltig.\nFehler der Schwere " + n2 + ": " + LomCoderErrors.sstrGetError(n);
        }
        this.objTextAreaStatus.setText(string);
    }

    private class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == AppletTestUI.this.objButtonCodiere) {
                try {
                    AppletTestUI.this.encodeLom();
                }
                catch (HitException hitException) {
                    // empty catch block
                }
            }
        }
    }

    private class TextFieldDatumHandler
    extends KeyAdapter {
        private TextFieldDatumHandler() {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                try {
                    AppletTestUI.this.encodeLom();
                }
                catch (HitException hitException) {
                    // empty catch block
                }
            }
        }
    }

    private class TextFieldLomHandler
    extends KeyAdapter {
        private TextFieldLomHandler() {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                try {
                    AppletTestUI.this.encodeLom();
                }
                catch (HitException hitException) {
                    // empty catch block
                }
            }
        }
    }

    private class QuitHandler
    extends WindowAdapter
    implements ActionListener {
        private QuitHandler() {
        }

        private void quit() {
            System.exit(0);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.quit();
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.quit();
        }
    }
}

