/*
 * Decompiled with CFR 0.152.
 */
package HitServer;

import HitUpros.LomCoder2;
import HitUpros.LomCoderErrors;
import HitUpros.LomDate;
import HitUpros.LomNumber;
import HitUpros.Lom_DE;
import java.math.BigInteger;
import java.sql.Date;

public class ServerLomCoder {
    public static int sintEncodeLom(String string, LomNumber lomNumber) {
        return ServerLomCoder.sintEncodeLom(string, lomNumber, LomDate.NOT_SET);
    }

    public static int sintEncodeLom(String string, LomNumber lomNumber, Date date) {
        int n = LomCoder2.sintEncodeLom(string, lomNumber, date);
        if (n < 0) {
            return n;
        }
        if (string.startsWith("#")) {
            return 0;
        }
        if (lomNumber.getCountry() == 276) {
            n = ServerLomCoder.pruefeLomBereich(lomNumber, date);
        }
        return n;
    }

    public static String sstrToString(LomNumber lomNumber) {
        return LomCoder2.sstrToString(lomNumber);
    }

    public static String sstrDecodeLom(LomNumber lomNumber) {
        return LomCoder2.sstrToFormattedString(lomNumber);
    }

    private static int pruefeLomBereich(LomNumber lomNumber, Date date) {
        if (date != LomDate.NOT_SET && date.equals(LomCoder2.scobjDateNoSerCheck)) {
            return 0;
        }
        int n = Lom_DE.intBundesland(lomNumber, date);
        if (LomCoderErrors.isError(n)) {
            return n;
        }
        BigInteger bigInteger = lomNumber.get();
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (ServerLomCoder.boolIstInSerie(bigInteger, "276000340000001", "276000350000000") || ServerLomCoder.boolIstInSerie(bigInteger, "276000350000001", "276000353000000") || ServerLomCoder.boolIstInSerie(bigInteger, "276000353000001", "276000354000000") || ServerLomCoder.boolIstInSerie(bigInteger, "276000354000001", "276000355000000") || ServerLomCoder.boolIstInSerie(bigInteger, "276000355000001", "276000356000000") || ServerLomCoder.boolIstInSerie(bigInteger, "276000356000001", "276000357000000") || ServerLomCoder.boolIstInSerie(bigInteger, "276000357000001", "276000360000000") || ServerLomCoder.boolIstInSerie(bigInteger, "276000360000001", "276000363000000") || ServerLomCoder.boolIstInSerie(bigInteger, "276000370000001", "276000372000000") || ServerLomCoder.boolIstInSerie(bigInteger, "276001000000000", "276001040000000")) break;
                return -13;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                if (ServerLomCoder.boolIstInSerie(bigInteger, "276000801000001", "276000818000000") || ServerLomCoder.boolIstInSerie(bigInteger, "276000890000001", "276000894000000")) break;
                return -13;
            }
            case 9: {
                if (ServerLomCoder.boolIstInSerie(bigInteger, "276000910000001", "276000919999999") || ServerLomCoder.boolIstInSerie(bigInteger, "276000920000001", "276000929999999") || ServerLomCoder.boolIstInSerie(bigInteger, "276000930000001", "276000947999999") || ServerLomCoder.boolIstInSerie(bigInteger, "276000948000000", "276000949999999") || ServerLomCoder.boolIstInSerie(bigInteger, "276000950000000", "276000951999999") || ServerLomCoder.boolIstInSerie(bigInteger, "276000952000000", "276000953999999") || ServerLomCoder.boolIstInSerie(bigInteger, "276000954000000", "276000957999999") || ServerLomCoder.boolIstInSerie(bigInteger, "276000971000001", "276000974365000") || ServerLomCoder.boolIstInSerie(bigInteger, "276000974370001", "276000976184000") || ServerLomCoder.boolIstInSerie(bigInteger, "276000980000001", "276000989999999")) break;
                return -13;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                break;
            }
        }
        return 0;
    }

    private static boolean boolIstInSerie(BigInteger bigInteger, String string, String string2) {
        BigInteger bigInteger2 = new BigInteger(string);
        BigInteger bigInteger3 = new BigInteger(string2);
        if (bigInteger.compareTo(bigInteger2) == 0) {
            return true;
        }
        if (bigInteger.compareTo(bigInteger3) == 0) {
            return true;
        }
        return bigInteger.compareTo(bigInteger2) == 1 && bigInteger.compareTo(bigInteger3) == -1;
    }
}

