/*
 * Decompiled with CFR 0.152.
 */
package HitUpros;

public class LomSchafeZiegen {
    protected static final int LOM_UNGUELTIG = 0;
    protected static final int LOM_BETRIEB = 1;
    protected static final int LOM_INDIVIDUELL = 2;
    protected int intThisStatus = 0;
    protected String strThisLomInput;
    protected String strThisLomNormalized;
    protected String strThisLomDenormalized;
    protected boolean boolThisForceDE = false;

    protected LomSchafeZiegen(String string, boolean bl) {
        this.strThisLomInput = string;
        if (bl) {
            this.pruefeIndividualLom(string);
        } else {
            this.pruefeBetriebsLom(string);
        }
    }

    public static LomSchafeZiegen fuerBetrieb(String string) {
        return new LomSchafeZiegen(string, false);
    }

    public static LomSchafeZiegen fuerEinzeltier(String string) {
        return new LomSchafeZiegen(string, true);
    }

    public boolean istBetriebsLom() {
        return this.intThisStatus == 1;
    }

    public boolean istIndividualLom() {
        return this.intThisStatus == 2;
    }

    public String getInput() {
        return this.strThisLomInput;
    }

    public String getNormalizedBetrieb() {
        return this.strThisLomNormalized;
    }

    public String getNormalizedIndividual() {
        return this.strThisLomNormalized;
    }

    public String getDenormalizedBetrieb() {
        if (!this.istBetriebsLom()) {
            return null;
        }
        return this.strThisLomDenormalized;
    }

    public String getDenormalizedIndividual() {
        if (!this.istIndividualLom()) {
            return null;
        }
        return this.strThisLomDenormalized;
    }

    protected void pruefeBetriebsLom(String string) {
        String string2 = this.normalizeBetrieb(string);
        if (string2 == null) {
            return;
        }
        if (this.isValidBetriebsLom(string2)) {
            this.strThisLomNormalized = string2;
            this.strThisLomDenormalized = string2.substring(0, 2) + " " + string2.substring(2, string2.length() - 7) + " " + string2.substring(string2.length() - 7);
            this.intThisStatus = 1;
        }
    }

    protected boolean isValidBetriebsLom(String string) {
        if (string == null) {
            return false;
        }
        try {
            if (!string.startsWith("DE")) {
                throw new Exception();
            }
            Long.parseLong(string.substring(string.length() - 7));
            String string2 = string.substring(2, string.length() - 7).toUpperCase();
            if (string2.length() < 1 || string2.length() > 3) {
                throw new Exception();
            }
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (c >= 'A' && c <= 'Z' || c == '\u00c4' || c == '\u00d6' || c == '\u00dc') continue;
                throw new Exception();
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected String normalizeBetrieb(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[]{' ', '\r', '\n', '\t', '-', '_'};
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            boolean bl = true;
            for (int j = 0; j < cArray.length; ++j) {
                if (c != cArray[j]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            stringBuffer.append(c);
        }
        if (!this.boolThisForceDE && !string.startsWith("DE")) {
            stringBuffer.insert(0, "DE");
        }
        return stringBuffer.toString().toUpperCase();
    }

    protected void pruefeIndividualLom(String string) {
        String string2 = this.normalizeIndividual(string);
        if (string2 == null) {
            return;
        }
        if (this.isValidIndividualLom(string2)) {
            this.strThisLomNormalized = string2;
            this.strThisLomDenormalized = "DE 01 " + string2.substring(5, 7) + " " + string2.substring(7, 10) + " " + string2.substring(10, 15);
            this.intThisStatus = 2;
        }
    }

    protected boolean isValidIndividualLom(String string) {
        if (string == null) {
            return false;
        }
        try {
            String string2 = null;
            if (string.startsWith("276")) {
                string2 = string.substring(3);
            }
            if (string2 == null) {
                throw new Exception();
            }
            if (string2.length() != 12) {
                throw new Exception();
            }
            Long.parseLong(string2.substring(0, 6));
            Long.parseLong(string2.substring(6));
            if (!string2.startsWith("01")) {
                throw new Exception();
            }
            int n = Integer.parseInt(string2.substring(2, 4));
            if (n < 1) {
                throw new Exception();
            }
            if (n > 16) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected String normalizeIndividual(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[]{' ', '\r', '\n', '\t', '-', '_'};
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            boolean bl = true;
            for (int j = 0; j < cArray.length; ++j) {
                if (c != cArray[j]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            stringBuffer.append(c);
        }
        String string2 = stringBuffer.toString().toUpperCase();
        if (string2.startsWith("DE")) {
            string2 = "276" + string2.substring(2);
        }
        return string2;
    }
}

