/*
 * Decompiled with CFR 0.152.
 */
package HitUpros;

import HitUpros.LomCoder2;
import HitUpros.LomCoderErrors;
import HitUpros.LomDate;
import HitUpros.LomEU;
import HitUpros.LomNumber;
import java.math.BigInteger;
import java.sql.Date;

public final class Lom_DE
extends LomEU {
    public static final int DE_SCHLESWIG_HOLSTEIN = 1;
    public static final int DE_HAMBURG = 2;
    public static final int DE_NIEDERSACHSEN = 3;
    public static final int DE_BREMEN = 4;
    public static final int DE_NORDRHEIN_WESTFALEN = 5;
    public static final int DE_NRW_WESTFALEN_LIPPE = 5;
    public static final int DE_NRW_RHEINLAND = 5;
    public static final int DE_NRW = 5;
    public static final int DE_HESSEN = 6;
    public static final int DE_RHEINLAND_PFALZ = 7;
    public static final int DE_BADEN_WUERTTEMBERG = 8;
    public static final int DE_BAYERN = 9;
    public static final int DE_SAARLAND = 10;
    public static final int DE_BERLIN = 11;
    public static final int DE_BRANDENBURG = 12;
    public static final int DE_MECKLENBURG_VORPOMMERN = 13;
    public static final int DE_SACHSEN = 14;
    public static final int DE_SACHSEN_ANHALT = 15;
    public static final int DE_THUERINGEN = 16;
    public static final int DE_SONDERFALL = 20;

    public Lom_DE() {
        this.setCountryParameters("DE", 276);
    }

    @Override
    public int isCountryEU(Date date) {
        return 1;
    }

    @Override
    protected int encodeLomDigits(String string, LomNumber lomNumber, Date date) {
        int n;
        int n2 = 0;
        try {
            Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -9;
        }
        n2 = this.pruefeLomLaenge(string, 10, 12);
        if (n2 != 0) {
            return n2;
        }
        int n3 = 2;
        long l = Integer.parseInt(string.substring(0, 2));
        if (l == 0L && string.length() == 10) {
            return -9;
        }
        if (l != 0L && string.length() == 12) {
            return -9;
        }
        if (l != 0L) {
            n3 = 0;
        }
        if (!((n = Integer.parseInt(string.substring(n3, n3 + 2))) > 0 && n <= 16 || n >= 20 && n <= 22)) {
            return -9;
        }
        if (!this.objBaueLom(lomNumber, string, this.getCountryCode())) {
            return -7;
        }
        n2 = this.pruefeLomBereich(lomNumber, date);
        if (n2 != 0) {
            return n2;
        }
        return n2;
    }

    @Override
    protected String decodeLomDigits(LomNumber lomNumber) {
        String string = Lom_DE.sstrToString(lomNumber);
        String string2 = string.substring(3);
        return this.getCountryId() + " " + string2.substring(2, 4) + " " + string2.substring(4, 7) + " " + string2.substring(7, 12);
    }

    @Override
    public boolean hasCheckdigit() {
        return false;
    }

    public static int intBundesland(LomNumber lomNumber, Date date) {
        if (lomNumber == null) {
            return -1;
        }
        String string = Lom_DE.sstrToString(lomNumber);
        String string2 = string.substring(3);
        int n = Integer.parseInt(string.substring(0, 3));
        if (n != 276) {
            return -5;
        }
        n = Integer.parseInt(string.substring(5, 7));
        BigInteger bigInteger = new BigInteger(string2);
        if (Lom_DE.isFirstBeforeSecond(date, scobjDate28101995) && (Lom_DE.boolIstInSerie(bigInteger, "1001000001", "1009500000") || Lom_DE.boolIstInSerie(bigInteger, "1011000001", "1011559800") || Lom_DE.boolIstInSerie(bigInteger, "1012000001", "1012350000") || Lom_DE.boolIstInSerie(bigInteger, "1013000001", "1013685000") || Lom_DE.boolIstInSerie(bigInteger, "1014000001", "1014623600") || Lom_DE.boolIstInSerie(bigInteger, "1015000001", "1015305300") || Lom_DE.boolIstInSerie(bigInteger, "1020000001", "1021639000") || Lom_DE.boolIstInSerie(bigInteger, "1024000001", "1024023000") || Lom_DE.boolIstInSerie(bigInteger, "1025000001", "1025500060") || Lom_DE.boolIstInSerie(bigInteger, "1026000001", "1026019000") || Lom_DE.boolIstInSerie(bigInteger, "1031000001", "1031733000") || Lom_DE.boolIstInSerie(bigInteger, "1032000001", "1032669700") || Lom_DE.boolIstInSerie(bigInteger, "1033000001", "1033334000") || Lom_DE.boolIstInSerie(bigInteger, "1034000001", "1034972000") || Lom_DE.boolIstInSerie(bigInteger, "1035000001", "1037712000") || Lom_DE.boolIstInSerie(bigInteger, "1038000001", "1038715000") || Lom_DE.boolIstInSerie(bigInteger, "1039000001", "1040000000"))) {
            return 3;
        }
        if (Lom_DE.boolIstInSerie(bigInteger, "2000000000", "2099999999")) {
            return 20;
        }
        if (Lom_DE.boolIstInSerie(bigInteger, "2100000001", "2199999999")) {
            return 20;
        }
        if (Lom_DE.boolIstInSerie(bigInteger, "2200000001", "2299999999")) {
            return 20;
        }
        if (n >= 1 && n <= 16) {
            return n;
        }
        return -9;
    }

    public static String strBundesland(int n) {
        switch (n) {
            case 1: {
                return "Schleswig-Holstein";
            }
            case 2: {
                return "Hamburg";
            }
            case 3: {
                return "Niedersachsen";
            }
            case 4: {
                return "Bremen";
            }
            case 5: {
                return "Nordrhein-Westfalen";
            }
            case 6: {
                return "Hessen";
            }
            case 7: {
                return "Rheinland-Pfalz";
            }
            case 8: {
                return "Baden-W\u00fcrttemberg";
            }
            case 9: {
                return "Bayern";
            }
            case 10: {
                return "Saarland";
            }
            case 11: {
                return "Berlin";
            }
            case 12: {
                return "Brandenburg";
            }
            case 13: {
                return "Mecklenburg-Vorpommern";
            }
            case 14: {
                return "Sachsen";
            }
            case 15: {
                return "Sachsen-Anhalt";
            }
            case 16: {
                return "Th\u00fcringen";
            }
        }
        return "???";
    }

    private int pruefeLomBereich(LomNumber lomNumber, Date date) {
        if (date != LomDate.NOT_SET && date.equals(LomCoder2.scobjDateNoSerCheck)) {
            return 0;
        }
        int n = Lom_DE.intBundesland(lomNumber, date);
        if (LomCoderErrors.isError(n)) {
            return n;
        }
        BigInteger bigInteger = lomNumber.get();
        switch (n) {
            case 9: {
                if (Lom_DE.boolIstInSerie(bigInteger, "276000910000000", "276000999999999")) break;
                return -13;
            }
        }
        if (date == LomDate.NOT_SET || date.equals(scobjDate01011900)) {
            return 0;
        }
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (Lom_DE.isFirstAfterSecond(date, scobjDate28101995)) {
                    if (Lom_DE.boolIstInSerie(bigInteger, "276000340000001", "276000399999999")) break;
                    return -13;
                }
                if (!Lom_DE.isFirstBeforeSecond(date, scobjDate28101995) || Lom_DE.boolIstInSerie(bigInteger, "276001001000001", "276001009500000") || Lom_DE.boolIstInSerie(bigInteger, "276001011000001", "276001011559800") || Lom_DE.boolIstInSerie(bigInteger, "276001012000001", "276001012350000") || Lom_DE.boolIstInSerie(bigInteger, "276001013000001", "276001013685000") || Lom_DE.boolIstInSerie(bigInteger, "276001014000001", "276001014623600") || Lom_DE.boolIstInSerie(bigInteger, "276001015000001", "276001015305300") || Lom_DE.boolIstInSerie(bigInteger, "276001020000001", "276001021639000") || Lom_DE.boolIstInSerie(bigInteger, "276001024000001", "276001024023000") || Lom_DE.boolIstInSerie(bigInteger, "276001025000001", "276001025500060") || Lom_DE.boolIstInSerie(bigInteger, "276001026000001", "276001026019000") || Lom_DE.boolIstInSerie(bigInteger, "276001031000001", "276001031733000") || Lom_DE.boolIstInSerie(bigInteger, "276001032000001", "276001032669700") || Lom_DE.boolIstInSerie(bigInteger, "276001033000001", "276001033334000") || Lom_DE.boolIstInSerie(bigInteger, "276001034000001", "276001034972000") || Lom_DE.boolIstInSerie(bigInteger, "276001035000001", "276001037712000") || Lom_DE.boolIstInSerie(bigInteger, "276001038000001", "276001038715000") || Lom_DE.boolIstInSerie(bigInteger, "276001039000001", "276001040000000")) break;
                return -13;
            }
            case 4: {
                if (!Lom_DE.isFirstAfterSecond(date, scobjDate28101995) || Lom_DE.boolIstInSerie(bigInteger, "276000416000001", "276000499999999")) break;
                return -13;
            }
            case 5: {
                if (Lom_DE.boolIstInSerie(bigInteger, "276000501000001", "276000501100000") || Lom_DE.boolIstInSerie(bigInteger, "276000503000001", "276000504000000") || Lom_DE.boolIstInSerie(bigInteger, "276000505000001", "276000506100000") || Lom_DE.boolIstInSerie(bigInteger, "276000509000001", "276000509460000") || Lom_DE.boolIstInSerie(bigInteger, "276000576100001", "276000576600000") || Lom_DE.boolIstInSerie(bigInteger, "276000576600001", "276000577695680") || Lom_DE.boolIstInSerie(bigInteger, "276000577700001", "276000577830650") || Lom_DE.boolIstInSerie(bigInteger, "276000577900001", "276000579100000") || Lom_DE.boolIstInSerie(bigInteger, "276000579100001", "276000581000000") || Lom_DE.boolIstInSerie(bigInteger, "276000532000001", "276000549999999")) break;
                return -13;
            }
            case 6: {
                if (!Lom_DE.isFirstBeforeSecond(date, scobjDate28101995) || Lom_DE.boolIstInSerie(bigInteger, "276000600000159", "276000609999999") || Lom_DE.boolIstInSerie(bigInteger, "276000660000001", "276000661500000") || Lom_DE.boolIstInSerie(bigInteger, "276000662000001", "276000662117000") || Lom_DE.boolIstInSerie(bigInteger, "276000663000001", "276000663118000") || Lom_DE.boolIstInSerie(bigInteger, "276000664000001", "276000664060000") || Lom_DE.boolIstInSerie(bigInteger, "276000665000001", "276000665136000")) break;
                return -13;
            }
            case 7: {
                long l;
                if (!Lom_DE.isFirstBeforeSecond(date, scobjDate28101995) || !Lom_DE.boolIstInSerie(bigInteger, "276000750000000", "276000767300006") && !Lom_DE.boolIstInSerie(bigInteger, "276000713650016", "276000713850007") || (l = bigInteger.longValue()) % 10L != 0L) break;
                return -13;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                if (!Lom_DE.boolIstInSerie(bigInteger, "276002120100001", "276002149999999")) break;
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                if (!Lom_DE.boolIstInSerie(bigInteger, "276002260100001", "276002269999999")) break;
                break;
            }
        }
        return 0;
    }

    private static boolean boolIstInSerie(BigInteger bigInteger, String string, String string2) {
        BigInteger bigInteger2 = new BigInteger(string);
        BigInteger bigInteger3 = new BigInteger(string2);
        if (bigInteger.compareTo(bigInteger2) == 0) {
            return true;
        }
        if (bigInteger.compareTo(bigInteger3) == 0) {
            return true;
        }
        return bigInteger.compareTo(bigInteger2) == 1 && bigInteger.compareTo(bigInteger3) == -1;
    }

    public static boolean isFirstAfterSecond(Date date, Date date2) {
        long l;
        if (date == LomDate.NOT_SET) {
            return false;
        }
        if (date2 == LomDate.NOT_SET) {
            return false;
        }
        long l2 = (date.getTime() + 43200000L) / 86400000L;
        return l2 > (l = (date2.getTime() + 43200000L) / 86400000L);
    }

    public static boolean isFirstBeforeSecond(Date date, Date date2) {
        return Lom_DE.isFirstAfterSecond(date2, date);
    }
}

