/*
 * Decompiled with CFR 0.152.
 */
package HitUpros;

import HitUpros.LomEU;
import HitUpros.LomNumber;
import java.math.BigInteger;
import java.sql.Date;

public final class Lom_IE
extends LomEU {
    private static char[] caCheckDigits = new char[]{'\u0000', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y'};

    public Lom_IE() {
        this.setCountryParameters("IE", 372, 930);
    }

    @Override
    public int isCountryEU(Date date) {
        return 1;
    }

    @Override
    protected int encodeLomDigits(String string, LomNumber lomNumber, Date date) {
        try {
            Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.length() == 9) {
                return this.encodeAlphaLom(string, lomNumber);
            }
            return -9;
        }
        int n = this.pruefeLomLaenge(string, 12);
        if (n != 0) {
            return n;
        }
        String string2 = string.substring(string.length() - 12);
        int n2 = this.calcCheckdigitFor(string2);
        if (n2 < 0) {
            return n2;
        }
        int n3 = Integer.parseInt(string2.substring(7, 8));
        if (n3 != n2) {
            return -6;
        }
        if (!this.objBaueLom(lomNumber, string2, this.getCountryCode())) {
            return -7;
        }
        return n;
    }

    @Override
    protected String decodeLomDigits(LomNumber lomNumber) {
        String string = Lom_IE.sstrToString(lomNumber);
        int n = Integer.parseInt(string.substring(0, 3));
        String string2 = string.substring(3);
        if (n == this.getCountryHIT()) {
            String string3 = this.decodeAlphaLom(string2);
            if (string3 == null) {
                return "#" + Lom_IE.sstrToString(lomNumber);
            }
            return string3;
        }
        string2 = string.substring(3);
        return this.getCountryId() + " " + string2.substring(0, 2) + " " + string2.substring(2, 7) + " " + string2.substring(7, 8) + " " + string2.substring(8, 12);
    }

    @Override
    public boolean hasCheckdigit() {
        return true;
    }

    public int calcCheckdigitFor(String string) {
        if (string.length() != 12) {
            return -4;
        }
        int n = 0;
        try {
            n += Integer.parseInt(string.substring(0, 1));
            n += 2 * Integer.parseInt(string.substring(1, 2));
            n += Integer.parseInt(string.substring(2, 3));
            n += 2 * Integer.parseInt(string.substring(3, 4));
            n += Integer.parseInt(string.substring(4, 5));
            n += 2 * Integer.parseInt(string.substring(5, 6));
            n += Integer.parseInt(string.substring(6, 7));
            n += 2 * Integer.parseInt(string.substring(8, 9));
            n += Integer.parseInt(string.substring(9, 10));
            n += 2 * Integer.parseInt(string.substring(10, 11));
            n += Integer.parseInt(string.substring(11, 12));
            while (n > 9) {
                int n2 = 0;
                for (int i = 0; i < Integer.toString(n).length(); ++i) {
                    n2 += Integer.parseInt(Integer.toString(n).substring(i, i + 1));
                }
                n = n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return -7;
        }
        return n;
    }

    private int encodeAlphaLom(String string, LomNumber lomNumber) {
        if (!Character.isLetter((string = string.toUpperCase()).charAt(0)) || !Character.isLetter(string.charAt(1)) || !Character.isLetter(string.charAt(2)) || !Character.isLetter(string.charAt(3)) || Character.isLetter(string.charAt(4)) || Character.isLetter(string.charAt(5)) || Character.isLetter(string.charAt(6)) || Character.isLetter(string.charAt(7)) || !Character.isLetter(string.charAt(8))) {
            return -9;
        }
        int n = 0;
        n += (string.charAt(0) - 65 + 1) * 9;
        n += (string.charAt(1) - 65 + 1) * 8;
        n += (string.charAt(2) - 65 + 1) * 7;
        n += (string.charAt(3) - 65 + 1) * 6;
        n += (string.charAt(4) - 48) * 5;
        n += (string.charAt(5) - 48) * 4;
        n += (string.charAt(6) - 48) * 3;
        int n2 = 23 - (n += (string.charAt(7) - 48) * 2) % 23;
        char c = '\u0000';
        try {
            c = caCheckDigits[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (string.charAt(8) != c) {
            return -6;
        }
        n = 0;
        n += (string.charAt(0) - 65) * 26 * 26 * 26;
        n += (string.charAt(1) - 65) * 26 * 26;
        n += (string.charAt(2) - 65) * 26;
        String string2 = "000000" + (n += string.charAt(3) - 65);
        string2 = string2.substring(string2.length() - 6);
        String string3 = "0" + n2;
        string3 = string3.substring(string3.length() - 2);
        String string4 = this.getCountryHIT() + string2 + string.substring(4, 8) + string3;
        lomNumber.set(new BigInteger(string4));
        return 0;
    }

    private String decodeAlphaLom(String string) {
        int n = Integer.parseInt(string.substring(0, 6));
        String string2 = "";
        int n2 = n / 17576;
        n -= n2 * 26 * 26 * 26;
        string2 = string2 + (char)(n2 + 65);
        n2 = n / 676;
        n -= n2 * 26 * 26;
        string2 = string2 + (char)(n2 + 65);
        n2 = n / 26;
        string2 = string2 + (char)(n2 + 65);
        string2 = string2 + (char)((n -= n2 * 26) + 65);
        char c = '\u0000';
        try {
            c = caCheckDigits[Integer.parseInt(string.substring(10))];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
        return "IE " + string2 + " " + string.substring(6, 10) + " " + c;
    }
}

