/*
 * Decompiled with CFR 0.152.
 */
package HitUpros;

import HitUpros.LomEU;
import HitUpros.LomNumber;
import java.math.BigInteger;
import java.sql.Date;

public final class Lom_IT
extends LomEU {
    private static String[] saRegionCodes = new String[]{"?", "TO", "VC", "NO", "CN", "AT", "AL", "AO", "IM", "SV", "GE", "SP", "VA", "CO", "SO", "MI", "BG", "BS", "PV", "CR", "MN", "BZ", "TN", "VR", "VI", "BL", "TV", "VE", "PD", "RO", "UD", "GO", "TS", "PC", "PR", "RE", "MO", "BO", "FE", "RA", "FO", "PS", "AN", "MC", "AP", "MS", "LU", "PT", "FI", "LI", "PI", "AR", "SI", "GR", "PG", "TR", "VT", "RI", "RM", "LT", "FR", "CE", "BN", "NA", "AV", "SA", "AQ", "TE", "PE", "CH", "CB", "FG", "BA", "TA", "BR", "LE", "PZ", "MT", "CS", "CZ", "RC", "TP", "PA", "ME", "AG", "CL", "EN", "CT", "RG", "SR", "SS", "NU", "CA", "PN", "IS", "OR", "BI", "LC", "LO", "RN", "PO", "KR", "VV", "VB"};

    public Lom_IT() {
        this.setCountryParameters("IT", 380, 91);
    }

    @Override
    public int isCountryEU(Date date) {
        return 1;
    }

    @Override
    protected int encodeLomDigits(String string, LomNumber lomNumber, Date date) {
        String string2;
        try {
            Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return this.encodeAlphaLom(string, lomNumber, date);
        }
        if (string.length() < 9) {
            return -2;
        }
        if (string.length() == 13) {
            string = string.substring(0, string.length() - 1);
        } else if (string.length() <= 12) {
            if (string.length() < 12) {
                string2 = new String("000000000" + string.substring(3));
                string2 = string2.substring(string2.length() - 9);
                string = string.substring(0, 3) + string2;
            }
        } else {
            return -3;
        }
        string2 = Lom_IT.getRegionCode(Integer.parseInt(string.substring(0, 3)));
        if (string2 == null) {
            return -12;
        }
        if (!this.objBaueLom(lomNumber, string, this.getCountryCode())) {
            return -7;
        }
        return 0;
    }

    private int encodeAlphaLom(String string, LomNumber lomNumber, Date date) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string2 = null;
        String string3 = null;
        boolean bl = true;
        if (string.length() < 8) {
            return -2;
        }
        if (bl && string.length() >= 8) {
            bl = false;
            try {
                n2 = Integer.parseInt(string.substring(2, 7));
                n3 = Integer.parseInt(string.substring(7));
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
            if (!bl) {
                int n5 = Lom_IT.getRegionCode(string.substring(0, 2));
                if (n5 < 0) {
                    return n5;
                }
                string2 = new String("00" + n5);
                string2 = string2.substring(string2.length() - 3);
                return this.encodeLomDigits(string2 + string.substring(2), lomNumber, date);
            }
        }
        if (string.length() != 12) {
            return -4;
        }
        if (bl) {
            bl = false;
            try {
                n2 = Integer.parseInt(string.substring(0, 3));
                n3 = Integer.parseInt(string.substring(5, 8));
                n4 = Integer.parseInt(string.substring(9, 12));
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
            string2 = string.substring(3, 5);
            string3 = string.substring(8, 9);
        }
        if (bl) {
            bl = false;
            try {
                n2 = Integer.parseInt(string.substring(2, 5));
                n3 = Integer.parseInt(string.substring(5, 8));
                n4 = Integer.parseInt(string.substring(9, 12));
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
            string2 = string.substring(0, 2);
            string3 = string.substring(8, 9);
        }
        if (bl) {
            return -9;
        }
        int n6 = Lom_IT.getRegionCode(string2);
        if (n6 < 0) {
            return n6;
        }
        int n7 = string3 != null && string3.length() > 0 ? (int)string3.charAt(0) : 45;
        switch (n7) {
            case 65: 
            case 66: 
            case 67: {
                n = n7 - 65;
                break;
            }
            default: {
                return -9;
            }
        }
        String string4 = new String("00" + n2);
        string4 = string4.substring(string4.length() - 3, string4.length());
        String string5 = new String("00" + n3);
        string5 = string5.substring(string5.length() - 3, string5.length());
        String string6 = new String("00" + n4);
        string6 = string6.substring(string6.length() - 3, string6.length());
        string2 = new String("00" + n6);
        string2 = string2.substring(string2.length() - 3, string2.length());
        string3 = new String("" + n);
        String string7 = this.getCountryHIT() + string2 + string3 + string4 + string5 + string6;
        lomNumber.set(new BigInteger(string7));
        return 0;
    }

    @Override
    protected String decodeLomDigits(LomNumber lomNumber) {
        String string = lomNumber.getLom();
        int n = Integer.parseInt(string.substring(0, 2));
        String string2 = string.substring(2);
        if (n == this.getCountryHIT()) {
            String string3 = this.decodeAlphaLom(string2);
            if (string3 == null) {
                return "#" + Lom_IT.sstrToString(lomNumber);
            }
            return string3;
        }
        string2 = string.substring(3);
        return this.getCountryId() + " " + string2.substring(0, 3) + " " + string2.substring(3, 5) + " " + string2.substring(5, 8) + " " + string2.substring(8, 12);
    }

    private String decodeAlphaLom(String string) {
        String string2;
        switch (Integer.parseInt(string.substring(3, 4))) {
            case 0: {
                string2 = "A";
                break;
            }
            case 1: {
                string2 = "B";
                break;
            }
            case 2: {
                string2 = "C";
                break;
            }
            default: {
                string2 = "?";
            }
        }
        return this.getCountryId() + " " + string.substring(4, 7) + " " + Lom_IT.getRegionCode(Integer.parseInt(string.substring(0, 3))) + " " + string.substring(7, 10) + " " + string2 + " " + string.substring(10, 13);
    }

    @Override
    public boolean hasCheckdigit() {
        return true;
    }

    private static int getRegionCode(String string) {
        if (string.length() == 2) {
            for (int i = 1; i < saRegionCodes.length; ++i) {
                if (!saRegionCodes[i].equalsIgnoreCase(string)) continue;
                return i;
            }
        }
        return -12;
    }

    private static String getRegionCode(int n) {
        if (n > 0 && n < saRegionCodes.length) {
            return saRegionCodes[n];
        }
        return null;
    }
}

