/*
 * Decompiled with CFR 0.152.
 */
package HitUpros;

import HitUpros.LomEU;
import HitUpros.LomNumber;
import java.sql.Date;

public final class Lom_PL
extends LomEU {
    public Lom_PL() {
        this.setLomValidFrom(scobjDate01052004);
        this.setCountryParameters("PL", 616);
    }

    @Override
    public int isCountryEU(Date date) {
        return this.isValidEULom(date);
    }

    @Override
    protected int encodeLomDigits(String string, LomNumber lomNumber, Date date) {
        try {
            Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -9;
        }
        int n = this.pruefeLomLaenge(string, 12);
        if (n != 0) {
            return n;
        }
        if (string.substring(0, 2).compareTo("00") != 0) {
            return -9;
        }
        long l = Long.parseLong(string.substring(2, 11));
        String string2 = string.substring(0, 11);
        int n2 = l >= 501369726L && l <= 501681125L || l >= 501913026L && l <= 502066375L || l >= 502326376L && l <= 502357425L || l >= 502376526L && l <= 502384225L || l >= 502386076L && l <= 502516975L || l >= 502524626L && l <= 502568525L || l >= 503693526L && l <= 503744925L || l >= 504186926L && l <= 504252075L || l >= 504390426L && l <= 504392425L || l >= 504394726L && l <= 504395725L || l >= 504405176L && l <= 504407025L || l >= 504413026L && l <= 504416625L || l >= 505693526L && l <= 505841325L ? this.calcCheckdigitFormula2For(string2) : this.calcCheckdigitFormula1For(string2);
        if (n2 < 0) {
            return n2;
        }
        if (n2 == 10) {
            n2 = 0;
        }
        if (n2 > 9) {
            return -9;
        }
        int n3 = Integer.parseInt(string.substring(string.length() - 1));
        if (n3 != n2) {
            return -6;
        }
        if (!this.objBaueLom(lomNumber, string, this.getCountryCode())) {
            return -7;
        }
        return 0;
    }

    @Override
    protected String decodeLomDigits(LomNumber lomNumber) {
        String string = Lom_PL.sstrToString(lomNumber);
        String string2 = string.substring(3);
        return this.getCountryId() + " " + string2.substring(0, 2) + " " + string2.substring(2, 7) + " " + string2.substring(7, 11) + " " + string2.substring(11, 12);
    }

    @Override
    public boolean hasCheckdigit() {
        return true;
    }

    protected int calcCheckdigitFormula1For(String string) {
        int n;
        if (string.length() != 11) {
            return -4;
        }
        int n2 = 0;
        try {
            n2 += 3 * Integer.parseInt(string.substring(0, 1));
            n2 += 1 * Integer.parseInt(string.substring(1, 2));
            n2 += 3 * Integer.parseInt(string.substring(2, 3));
            n2 += 1 * Integer.parseInt(string.substring(3, 4));
            n2 += 3 * Integer.parseInt(string.substring(4, 5));
            n2 += 1 * Integer.parseInt(string.substring(5, 6));
            n2 += 3 * Integer.parseInt(string.substring(6, 7));
            n2 += 1 * Integer.parseInt(string.substring(7, 8));
            n2 += 3 * Integer.parseInt(string.substring(8, 9));
            n2 += 1 * Integer.parseInt(string.substring(9, 10));
            n = (10 - (n2 += 3 * Integer.parseInt(string.substring(10, 11))) % 10) % 10;
        }
        catch (NumberFormatException numberFormatException) {
            return -11;
        }
        return n;
    }

    protected int calcCheckdigitFormula2For(String string) {
        if (string.length() != 11) {
            return -4;
        }
        try {
            int n = Integer.parseInt(string.substring(2, 7));
            int n2 = Integer.parseInt(string.substring(7, 11));
            return 1 + (5 * n + n2) % 7;
        }
        catch (NumberFormatException numberFormatException) {
            return -11;
        }
    }
}

