/*
 * Decompiled with CFR 0.152.
 */
package HitUpros;

import HitUpros.HitConsts;
import HitUpros.HitException;
import HitUpros.HitHelpers;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.StringTokenizer;

public class HitSimpleDTS {
    private static final int scintVOR_TAG = 0;
    private static final int scintIN_TAG = 1;
    private static final int scintNACH_TAG = 2;
    private static final int scintVOR_MONAT = 3;
    private static final int scintIN_MONAT = 4;
    private static final int scintNACH_MONAT = 5;
    private static final int scintVOR_JAHR = 6;
    private static final int scintIN_JAHR = 7;
    private static final int scintNACH_JAHR = 8;
    private static final int scintVOR_HH = 0;
    private static final int scintIN_HH = 1;
    private static final int scintNACH_HH = 2;
    private static final int scintVOR_MM = 3;
    private static final int scintIN_MM = 4;
    private static final int scintNACH_MM = 5;
    private static final int scintVOR_SS = 6;
    private static final int scintIN_SS = 7;
    private static final int scintNACH_SS = 8;
    private static final int scintIN_ERROR = 9;
    public static final int scintDateAppendNone = 0;
    public static final int scintDateAppendTageszahl = 1;
    public static final int scintDateAppendMonatJahrVorher = 2;
    public static final int scintDateAppendMonatJahrAkt = 3;
    public static final int scintDateAppendJahrVorher = 4;
    public static final int scintDateAppendJahrAkt = 5;
    public static final int scintDateAppendJahrhundertVorher = 6;
    public static final int scintDateAppendJahrhundertAkt = 7;
    public static final int scintDateAppendStunde = 8;
    public static final int scintDateAppendMinute = 9;
    public static final int scintDateAppendSekunde = 10;
    public static final int scintDateAppendMikro = 11;
    public static final int scintDateAppendNextDayWg24h = 99;
    public static final int sintFillupNothing = -2;
    public static final int sintFillupVerySmart = -5;
    public static final int sintFillupYearCurrent = -6;
    public static final int sintFillupYearNoFuture = -7;
    public static final int sintFillupYearNoFutureNoCheck = -9;
    public static final int sintFillupCenturyCurrent = -3;
    public static final int sintFillupCenturyNoFuture = -4;
    public static final int sintFillupCenturyNoFutureNoCheck = -8;
    public static final int[][] caaintMonatstage = new int[][]{{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}, {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};
    private static BigDecimal scobjDec1div31 = new BigDecimal(3.2258064516129);
    private static String[] csastrWochentage = new String[]{"SO", "MO", "DI", "MI", "DO", "FR", "SA"};
    public static final int scintRESOLUTION_NULL = 0;
    public static final int scintRESOLUTION_DATE = 1;
    public static final int scintRESOLUTION_HOUR = 2;
    public static final int scintRESOLUTION_MIN = 3;
    public static final int scintRESOLUTION_SEC = 4;
    public static final int scintRESOLUTION_NANO = 5;

    public static boolean sblnBefore(java.util.Date date, java.util.Date date2) {
        long l;
        long l2 = HitSimpleDTS.slngGetTagx(date);
        return l2 < (l = HitSimpleDTS.slngGetTagx(date2));
    }

    public static boolean sblnBeforeOrEQ(java.util.Date date, java.util.Date date2) {
        long l;
        long l2 = HitSimpleDTS.slngGetTagx(date);
        return l2 <= (l = HitSimpleDTS.slngGetTagx(date2));
    }

    public static int sintCompareTo(java.util.Date date, java.util.Date date2) {
        long l;
        long l2 = HitSimpleDTS.slngGetTagx(date);
        if (l2 < (l = HitSimpleDTS.slngGetTagx(date2))) {
            return -1;
        }
        if (l2 > l) {
            return 1;
        }
        return 0;
    }

    public static boolean sblnBetween(java.util.Date date, java.util.Date date2, java.util.Date date3) {
        long l = HitSimpleDTS.slngGetTagx(date);
        long l2 = HitSimpleDTS.slngGetTagx(date2);
        long l3 = HitSimpleDTS.slngGetTagx(date3);
        return l2 <= l && l <= l3;
    }

    public static long slngGetTagx(java.util.Date date) {
        return (date.getTime() + 43200000L) / 86400000L;
    }

    public static boolean sblnEquals(java.util.Date date, java.util.Date date2) {
        long l;
        if (date == null && date2 == null) {
            return true;
        }
        if (date == null || date2 == null) {
            return false;
        }
        long l2 = HitSimpleDTS.slngGetTagx(date);
        return l2 == (l = HitSimpleDTS.slngGetTagx(date2));
    }

    public static boolean sblnAfter(java.util.Date date, java.util.Date date2) {
        long l;
        long l2 = HitSimpleDTS.slngGetTagx(date);
        return l2 > (l = HitSimpleDTS.slngGetTagx(date2));
    }

    public static boolean sblnAfterOrEQ(java.util.Date date, java.util.Date date2) {
        long l;
        long l2 = HitSimpleDTS.slngGetTagx(date);
        return l2 >= (l = HitSimpleDTS.slngGetTagx(date2));
    }

    public static boolean sblnBefore(Timestamp timestamp, Timestamp timestamp2) {
        long l;
        long l2 = timestamp.getTime();
        return l2 < (l = timestamp2.getTime());
    }

    public static boolean sblnBeforeOrEQ(Timestamp timestamp, Timestamp timestamp2) {
        long l;
        long l2 = timestamp.getTime();
        return l2 <= (l = timestamp2.getTime());
    }

    public static boolean sblnBetween(Timestamp timestamp, Timestamp timestamp2, Timestamp timestamp3) {
        long l = timestamp.getTime();
        long l2 = timestamp2.getTime();
        long l3 = timestamp3.getTime();
        return l2 <= l && l <= l3;
    }

    public static boolean sblnIntersect(Timestamp timestamp, Timestamp timestamp2, Timestamp timestamp3, Timestamp timestamp4) {
        boolean bl = false;
        long l = HitSimpleDTS.slngGetTagx(timestamp);
        long l2 = HitSimpleDTS.slngGetTagx(timestamp2);
        long l3 = HitSimpleDTS.slngGetTagx(timestamp3);
        long l4 = HitSimpleDTS.slngGetTagx(timestamp4);
        bl = l4 < l ? false : l3 <= l2;
        return bl;
    }

    public static boolean sblnIntersect(Date date, Date date2, Date date3, Date date4) {
        boolean bl = false;
        long l = date.getTime();
        long l2 = date2.getTime();
        long l3 = date3.getTime();
        long l4 = date4.getTime();
        bl = l4 <= l ? false : l3 < l2;
        return bl;
    }

    public static boolean sblnEquals(Timestamp timestamp, Timestamp timestamp2) {
        if (timestamp == null && timestamp2 == null) {
            return true;
        }
        if (timestamp == null || timestamp2 == null) {
            return false;
        }
        long l = timestamp == null ? -1L : timestamp.getTime();
        long l2 = timestamp2 == null ? -1L : timestamp2.getTime();
        return l == l2;
    }

    public static boolean sblnAfter(Timestamp timestamp, Timestamp timestamp2) {
        long l;
        long l2 = timestamp.getTime();
        return l2 > (l = timestamp2.getTime());
    }

    public static boolean sblnAfterOrEQ(Timestamp timestamp, Timestamp timestamp2) {
        long l;
        long l2 = timestamp.getTime();
        return l2 >= (l = timestamp2.getTime());
    }

    public static Date sobjDateAddDays(Date date, int n) {
        if (date == null) {
            date = HitSimpleDTS.sobjSqlDateHeute();
        }
        Date date2 = null;
        if (date != null) {
            date2 = new Date(98, 0, 1);
            date2.setDate(date.getDate() + n);
            date2.setMonth(date.getMonth());
            date2.setYear(date.getYear());
        }
        return date2;
    }

    public static Timestamp sobjTimestampAddDays(Timestamp timestamp, int n) {
        Timestamp timestamp2 = null;
        if (timestamp != null) {
            timestamp2 = new Timestamp(98, 0, 1, 0, 0, 0, 0);
            timestamp2.setDate(timestamp.getDate() + n);
            timestamp2.setMonth(timestamp.getMonth());
            timestamp2.setYear(timestamp.getYear());
            timestamp2.setHours(timestamp.getHours());
            timestamp2.setMinutes(timestamp.getMinutes());
            timestamp2.setSeconds(timestamp.getSeconds());
            timestamp2.setNanos(timestamp.getNanos());
        }
        return timestamp2;
    }

    public static Timestamp sobjTimestampAddMonthsAndYears(Timestamp timestamp, int n, int n2) {
        Timestamp timestamp2 = null;
        if (timestamp != null) {
            timestamp2 = (Timestamp)timestamp.clone();
            if (n != 0) {
                timestamp2.setMonth(timestamp.getMonth() + n);
            }
            if (n2 != 0) {
                timestamp2.setYear(timestamp.getYear() + n2);
            }
        }
        return timestamp2;
    }

    public static Timestamp sobjTimestampAddSeconds(Timestamp timestamp, int n) {
        Timestamp timestamp2 = null;
        if (timestamp != null) {
            timestamp2 = new Timestamp(98, 0, 1, 0, 0, 0, 0);
            timestamp2.setDate(timestamp.getDate());
            timestamp2.setMonth(timestamp.getMonth());
            timestamp2.setYear(timestamp.getYear());
            timestamp2.setHours(timestamp.getHours());
            timestamp2.setMinutes(timestamp.getMinutes());
            timestamp2.setSeconds(timestamp.getSeconds() + n);
            timestamp2.setNanos(timestamp.getNanos());
        }
        return timestamp2;
    }

    public static Date sobjDateJahresBeginn(Date date) {
        Date date2 = null;
        if (date != null) {
            date2 = new Date(98, 0, 1);
            date2.setDate(date.getDate() + 1);
            date2.setMonth(date.getMonth());
            date2.setYear(date.getYear() - 1);
        }
        return date2;
    }

    public static Date sobjDaySinceBegin2Date(long l) {
        Date date = null;
        date = new Date(70, 0, 1);
        date.setDate(date.getDate() + (int)l);
        return date;
    }

    public static Date sobjDateAddMonthsAndYears(Date date, int n, int n2, int n3) {
        Date date2 = null;
        if (date != null) {
            date2 = new Date(98, 0, 1);
            date2.setDate(date.getDate());
            int n4 = date.getMonth() + n;
            while (n4 < 0) {
                n4 += 12;
                --n2;
            }
            while (n4 > 11) {
                n4 -= 12;
                ++n2;
            }
            date2.setMonth(n4);
            date2.setYear(date.getYear() + n2);
            if ((n4 %= 12) < 0) {
                n4 += 12;
            }
            boolean bl = false;
            while (date2.getMonth() != n4) {
                bl = true;
                int n5 = date2.getDate();
                int n6 = date2.getMonth();
                date2.setDate(date2.getDate() - 1);
            }
            if (bl) {
                if (n3 == 0) {
                    date2 = null;
                } else if (n3 == 1) {
                    date2.setDate(date2.getDate() + 1);
                }
            }
        }
        return date2;
    }

    public static BigDecimal sintMONTHS_BETWEEN(Date date, Date date2) {
        BigDecimal bigDecimal = HitSimpleDTS.sobjMonatTagesDiffenenz(date2, date);
        BigDecimal bigDecimal2 = bigDecimal.remainder(BigDecimal.ONE);
        BigDecimal bigDecimal3 = bigDecimal.subtract(bigDecimal2);
        bigDecimal = bigDecimal3.add(bigDecimal2.multiply(scobjDec1div31));
        return bigDecimal;
    }

    public static BigDecimal sobjMonatTagesDiffenenz(Date date, Date date2) {
        BigDecimal bigDecimal = null;
        if (date != null && date2 != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy/HH.mm.ss.SSS");
            String string = simpleDateFormat.format(date2);
            String string2 = simpleDateFormat.format(date);
            boolean bl = false;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            if (date.getTime() > date2.getTime()) {
                bl = true;
                n = HitHelpers.sobjInteger(string2.substring(6, 10));
                n2 = HitHelpers.sobjInteger(string2.substring(3, 5));
                n3 = HitHelpers.sobjInteger(string2.substring(0, 2));
                n4 = HitHelpers.sobjInteger(string.substring(6, 10));
                n5 = HitHelpers.sobjInteger(string.substring(3, 5));
                n6 = HitHelpers.sobjInteger(string.substring(0, 2));
            } else {
                n = HitHelpers.sobjInteger(string.substring(6, 10));
                n2 = HitHelpers.sobjInteger(string.substring(3, 5));
                n3 = HitHelpers.sobjInteger(string.substring(0, 2));
                n4 = HitHelpers.sobjInteger(string2.substring(6, 10));
                n5 = HitHelpers.sobjInteger(string2.substring(3, 5));
                n6 = HitHelpers.sobjInteger(string2.substring(0, 2));
            }
            int n7 = n - n4;
            int n8 = n2 - n5;
            int n9 = n3 - n6;
            if (n9 < 0) {
                --n8;
                if (n2 > 1) {
                    --n2;
                } else {
                    n2 = 12;
                    --n;
                }
                n9 = HitSimpleDTS.sintMonatstage(n, n2) - n6;
                if (n9 < 0) {
                    n9 = 0;
                }
                n9 += n3;
            }
            long l = (n7 * 12 + n8) * 100 + n9;
            bigDecimal = new BigDecimal(l).divide(HitHelpers.scobjBig10E2, 2, 7);
            if (bl) {
                bigDecimal = bigDecimal.negate();
            }
        }
        return bigDecimal;
    }

    private static long slngGetDaysX(Date date) {
        return (date.getYear() * 12 + date.getMonth()) * 31 + date.getDate();
    }

    public static BigDecimal sobjMonatTagesDiffenenzDec(Date date, Date date2) {
        BigDecimal bigDecimal = null;
        if (date != null && date2 != null) {
            long l = HitSimpleDTS.slngGetDaysX(date);
            long l2 = HitSimpleDTS.slngGetDaysX(date2);
            long l3 = l2 - l;
            try {
                bigDecimal = new BigDecimal(l3).divide(HitConsts.scobjDec31, 5, 4).setScale(5);
            }
            catch (Exception exception) {
                bigDecimal = null;
            }
        }
        return bigDecimal;
    }

    public static String sstrGetMonTg(BigDecimal bigDecimal) {
        String string = null;
        if (bigDecimal != null) {
            BigDecimal bigDecimal2 = bigDecimal.setScale(0, 1);
            BigDecimal bigDecimal3 = bigDecimal.subtract(bigDecimal2);
            string = bigDecimal2.toString() + " Mon. " + bigDecimal3.toString().substring(2) + " Tg.";
        }
        return string;
    }

    public static int sintDb2Days(Date date) {
        int n = -1;
        if (date != null) {
            n = (int)(date.getTime() / 86400000L) - 10859 + 730023;
        }
        return n;
    }

    public static int sintMonatstage(int n, int n2) {
        int n3 = -1;
        switch (n2) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                n3 = 31;
                break;
            }
            case 2: {
                n3 = HitSimpleDTS.sblnSchaltJahr(n) ? 29 : 28;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                n3 = 30;
            }
        }
        return n3;
    }

    public static Date sobjDays2Db2(int n) {
        Date date = null;
        if (n >= 0) {
            date = new Date((long)(n - 730023 + 10859 + 1) * 86400000L);
        }
        return date;
    }

    public static long slngDaySinceBegin(Date date) {
        long l = Integer.MIN_VALUE;
        if (date != null) {
            long l2 = (long)date.getTimezoneOffset() * 60000L;
            long l3 = date.getTime();
            l = l3 >= 0L ? (l3 - l2) / 86400000L : (l3 + l2) / 86400000L;
        }
        return l;
    }

    public static int sintTagesDiffenenz(Date date, Date date2) {
        int n;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("DDD.yyyy/HH.mm.ss.SSS");
        String string = simpleDateFormat.format(date2);
        String string2 = simpleDateFormat.format(date);
        int n2 = HitHelpers.sobjInteger(string.substring(4, 8));
        int n3 = HitHelpers.sobjInteger(string.substring(0, 3));
        int n4 = HitHelpers.sobjInteger(string2.substring(4, 8));
        int n5 = HitHelpers.sobjInteger(string2.substring(0, 3));
        int n6 = n3 - n5;
        if (n4 < n2) {
            for (n = n4; n < n2; ++n) {
                if (HitSimpleDTS.sblnSchaltJahr(n)) {
                    n6 += 366;
                    continue;
                }
                n6 += 365;
            }
        }
        if (n4 > n2) {
            for (n = n4 - 1; n >= n2; --n) {
                if (HitSimpleDTS.sblnSchaltJahr(n)) {
                    n6 -= 366;
                    continue;
                }
                n6 -= 365;
            }
        }
        return n6;
    }

    public static Date sobjMax(Date date, Date date2) {
        Date date3 = null;
        date3 = date == null ? date2 : (date2 == null ? date : (date.getTime() > date2.getTime() ? date : date2));
        return date3;
    }

    public static Date sobjMin(Date date, Date date2) {
        Date date3 = null;
        date3 = date == null ? date2 : (date2 == null ? date : (date.getTime() < date2.getTime() ? date : date2));
        return date3;
    }

    public static Timestamp sobjMax(Timestamp timestamp, Timestamp timestamp2) {
        Timestamp timestamp3 = null;
        timestamp3 = timestamp == null ? timestamp2 : (timestamp2 == null ? timestamp : (timestamp.getTime() > timestamp2.getTime() ? timestamp : timestamp2));
        return timestamp3;
    }

    public static Timestamp sobjMin(Timestamp timestamp, Timestamp timestamp2) {
        Timestamp timestamp3 = null;
        timestamp3 = timestamp == null ? timestamp2 : (timestamp2 == null ? timestamp : (timestamp.getTime() < timestamp2.getTime() ? timestamp : timestamp2));
        return timestamp3;
    }

    public static Date sobjToDate(String string) throws HitException {
        if (string == null) {
            throw new HitException("Datum nicht angegeben");
        }
        Date date = new Date(98, 0, 1);
        int n = HitSimpleDTS.sintStrToSqlDateKurz(string, date, -3);
        return date;
    }

    public static Date sobjSqlDateHeute() {
        java.util.Date date = new java.util.Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy/HH.mm.ss.SSS");
        String string = simpleDateFormat.format(date).substring(0, 10);
        try {
            Date date2 = new Date(98, 0, 1);
            HitSimpleDTS.sintStrToSqlDate(string, date2);
            return date2;
        }
        catch (Exception exception) {
            throw new RuntimeException();
        }
    }

    public static String sstrSqlDateHeute() {
        return HitSimpleDTS.sstrToString(HitSimpleDTS.sobjSqlDateHeute());
    }

    public static Timestamp sobjSqlTimestampHeute() {
        java.util.Date date = new java.util.Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy");
        String string = simpleDateFormat.format(date).substring(0, 10);
        try {
            Timestamp timestamp = new Timestamp(0L);
            HitSimpleDTS.sintStrToSqlTimeStamp(string, timestamp);
            return timestamp;
        }
        catch (Exception exception) {
            throw new RuntimeException();
        }
    }

    public static String sstrSqlTimestampHeute() {
        return HitSimpleDTS.sstrToString(HitSimpleDTS.sobjSqlTimestampHeute());
    }

    public static Timestamp sobjSqlTimestampJetzt() {
        java.util.Date date = new java.util.Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy/HH.mm.ss.SSS");
        String string = simpleDateFormat.format(date);
        try {
            Timestamp timestamp = new Timestamp(0L);
            HitSimpleDTS.sintStrToSqlTimeStamp(string, timestamp);
            return timestamp;
        }
        catch (Exception exception) {
            throw new RuntimeException();
        }
    }

    public static String sstrSqlTimestampJetzt() {
        return HitSimpleDTS.sstrToString(HitSimpleDTS.sobjSqlTimestampJetzt());
    }

    public static Time sobjSqlTimeJetzt() {
        java.util.Date date = new java.util.Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy/HH.mm.ss.SSS");
        String string = simpleDateFormat.format(date).substring(11, 19);
        try {
            Time time = new Time(0L);
            HitSimpleDTS.sintStrToSqlTime(string, time);
            return time;
        }
        catch (Exception exception) {
            throw new RuntimeException();
        }
    }

    public static String sstrSqlTimeJetzt() {
        return HitSimpleDTS.sstrToString(HitSimpleDTS.sobjSqlTimeJetzt());
    }

    public static final Date sobjStrToSqlDate(String string) throws HitException {
        if (string == null) {
            throw new HitException("Datum nicht angegeben");
        }
        Date date = new Date(98, 0, 1);
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            int n = Integer.valueOf(stringTokenizer.nextToken());
            int n2 = Integer.valueOf(stringTokenizer.nextToken());
            int n3 = Integer.valueOf(stringTokenizer.nextToken());
            date.setDate(n);
            date.setMonth(n2 - 1);
            date.setYear(n3 - 1900);
        }
        catch (Exception exception) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
                int n = Integer.valueOf(stringTokenizer.nextToken());
                int n4 = Integer.valueOf(stringTokenizer.nextToken());
                int n5 = Integer.valueOf(stringTokenizer.nextToken());
                date.setDate(n5);
                date.setMonth(n4 - 1);
                date.setYear(n - 1900);
            }
            catch (Exception exception2) {
                throw new HitException("Invalid Format in HitHelper.sobjStrToSqlDate <" + string + ">");
            }
        }
        return date;
    }

    public static final int sintStrToSqlDate(String string, Date date) throws HitException {
        String string2;
        String string3;
        String string4;
        if (string == null) {
            throw new HitException("Datum nicht angegeben");
        }
        string = HitSimpleDTS.sstrDateDb2ToStd(string);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        try {
            string4 = stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            throw new HitException(7, "Nicht im Format TT.MM.JJJJ");
        }
        try {
            n2 = HitHelpers.sobjInteger(string4);
        }
        catch (Exception exception) {
            throw new HitException(7, "Fehler bei Tag");
        }
        try {
            n3 = HitHelpers.sobjInteger(string3);
        }
        catch (Exception exception) {
            throw new HitException(7, "Fehler bei Monat");
        }
        try {
            n4 = HitHelpers.sobjInteger(string2);
        }
        catch (Exception exception) {
            throw new HitException(7, "Fehler bei Jahr");
        }
        if (stringTokenizer.hasMoreTokens()) {
            throw new HitException(7, "Nicht im Format TT.MM.JJJJ");
        }
        if (n2 < 1 || n2 > 31) {
            throw new HitException(7, "Falsche Tagesangabe");
        }
        if (n3 < 1 || n3 > 12) {
            throw new HitException(7, "Falsche Monatsangabe");
        }
        if (n4 < 1800 || n4 > 2100) {
            throw new HitException(7, "Falsche Jahresangabe");
        }
        switch (n3) {
            case 2: {
                if (n2 <= 29 && (HitSimpleDTS.sblnSchaltJahr(n4) || n2 <= 28)) break;
                throw new HitException(7, "Falsche Tagesangabe");
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                if (n2 <= 30) break;
                throw new HitException(7, "Falsche Tagesangabe");
            }
        }
        date.setDate(n2);
        date.setMonth(n3 - 1);
        date.setYear(n4 - 1900);
        return n;
    }

    public static final String sstrFormatHitDate(String string, String string2) throws HitException {
        if (string2 == null) {
            throw new HitException("Format NULL in HitHelper.sstrFormatHitDate");
        }
        String string3 = null;
        if (string != null) {
            Date date = new Date(98, 0, 1);
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
                int n = Integer.valueOf(stringTokenizer.nextToken());
                int n2 = Integer.valueOf(stringTokenizer.nextToken());
                int n3 = Integer.valueOf(stringTokenizer.nextToken());
                date.setDate(n);
                date.setMonth(n2 - 1);
                date.setYear(n3 - 1900);
            }
            catch (Exception exception) {
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
                    int n = Integer.valueOf(stringTokenizer.nextToken());
                    int n4 = Integer.valueOf(stringTokenizer.nextToken());
                    int n5 = Integer.valueOf(stringTokenizer.nextToken());
                    date.setDate(n5);
                    date.setMonth(n4 - 1);
                    date.setYear(n - 1900);
                }
                catch (Exception exception2) {
                    date = null;
                }
            }
            string3 = HitSimpleDTS.sstrFormatHitDate(date, string2);
        }
        return string3;
    }

    public static final String sstrFormatHitDate(Date date, String string) throws HitException {
        if (string == null) {
            throw new HitException("Format NULL in HitHelper.sstrFormatHitDate");
        }
        String string2 = null;
        try {
            if (date != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
                string2 = simpleDateFormat.format(date);
            }
        }
        catch (Exception exception) {
            throw new HitException("Invalid Format in HitHelper.sstrFormatHitDate <" + date + ">");
        }
        return string2;
    }

    public static final String sstrToString(Date date) {
        if (date == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(12);
        int n = date.getDate();
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n).append('.');
        n = date.getMonth() + 1;
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n).append('.');
        n = date.getYear() + 1900;
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
        return stringBuffer.toString();
    }

    public static final int sintToWeekday(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setMinimalDaysInFirstWeek(4);
        calendar.setTime(date);
        int n = calendar.get(7) - 1;
        if (n == 0) {
            n = 7;
        }
        return n;
    }

    public static final int sintToKw(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setMinimalDaysInFirstWeek(4);
        calendar.setTime(date);
        return calendar.get(3);
    }

    public static final String _sstrToDb2String(Date date) {
        return HitSimpleDTS._sstrToDBxString(date, '-', '-');
    }

    public static final String _sstrToPostgreString(Date date) {
        return HitSimpleDTS._sstrToDBxString(date, '-', '-');
    }

    private static final String _sstrToDBxString(Date date, char c, char c2) {
        if (date == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("'");
        int n = date.getYear() + 1900;
        stringBuffer.append(n).append(c);
        n = date.getMonth() + 1;
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n).append(c2);
        n = date.getDate();
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    public static final String _sstrToDb2StringOld(Date date) {
        if (date == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("'");
        int n = date.getDate();
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n).append('.');
        n = date.getMonth() + 1;
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n).append('.');
        n = date.getYear() + 1900;
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    public static final boolean sblnEquals(Date date, Date date2) {
        long l;
        if (date == null && date2 == null) {
            return true;
        }
        if (date == null || date2 == null) {
            return false;
        }
        long l2 = HitSimpleDTS.slngGetTagx(date);
        return l2 == (l = HitSimpleDTS.slngGetTagx(date2));
    }

    public static final boolean sblnEqualsOrMiss(Date date, Date date2) {
        if (date == null || date2 == null || date.toString().length() == 0 || date2.toString().length() == 0) {
            return true;
        }
        return date.getTime() == date2.getTime();
    }

    public static final boolean sblnEquals(Time time, Time time2) {
        if (time == null && time2 == null) {
            return true;
        }
        if (time == null || time2 == null) {
            return false;
        }
        if (time.getTime() == time2.getTime()) {
            return true;
        }
        return time.toString().equals(time2.toString());
    }

    public static final int sintStrToSqlDateKurz(String string, Date date, int n) throws HitException {
        int n2;
        int n3;
        int n4;
        boolean bl = false;
        int n5 = 0;
        string = string.trim();
        int n6 = string.length();
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        if (n6 == 10) {
            string = HitSimpleDTS.sstrDateDb2ToStd(string);
        }
        block38: for (int i = 0; i < n6 && n10 < 9; ++i) {
            switch (string.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    switch (n10) {
                        case 0: {
                            n7 = string.charAt(i) - 48;
                            n10 = 1;
                            break;
                        }
                        case 1: {
                            n7 = 10 * n7 + string.charAt(i) - 48;
                            n10 = 2;
                            break;
                        }
                        case 2: 
                        case 3: {
                            n8 = string.charAt(i) - 48;
                            n10 = 4;
                            break;
                        }
                        case 4: {
                            n8 = 10 * n8 + string.charAt(i) - 48;
                            n10 = 5;
                            break;
                        }
                        case 5: 
                        case 6: {
                            n9 = string.charAt(i) - 48;
                            n10 = 7;
                            break;
                        }
                        case 7: {
                            n9 = 10 * n9 + string.charAt(i) - 48;
                            if (++n11 < 3) break;
                            n10 = 8;
                            break;
                        }
                        case 8: {
                            throw new HitException(7, "Falsches Datumsformat");
                        }
                    }
                    continue block38;
                }
                case ' ': 
                case ',': 
                case '.': 
                case '/': 
                case ';': {
                    switch (n10) {
                        case 1: 
                        case 2: {
                            n10 = 3;
                            continue block38;
                        }
                        case 4: 
                        case 5: {
                            n10 = 6;
                            continue block38;
                        }
                        case 3: 
                        case 6: {
                            throw new HitException(7, "Mehrere Trennzeichen hintereinander");
                        }
                    }
                    throw new HitException(7, "Falsches Trennzeichen");
                }
                default: {
                    throw new HitException(7, "Falsches Zeichen in Datum");
                }
            }
        }
        if (n6 == 8 && n10 == 8 && n9 >= 100 && n9 <= 1299) {
            int n12 = n7;
            n4 = n8;
            n3 = n9;
            int n13 = n3 % 100;
            n2 = (n3 - n13) / 100;
            int n14 = n12 * 100 + n4;
            if (n13 >= 1 && n13 <= 31 && n2 >= 1 && n2 <= 12 && n14 >= 1900 && n14 <= 2100) {
                n7 = n13;
                n8 = n2;
                n9 = n14;
            }
        }
        Date date2 = HitSimpleDTS.sobjSqlDateHeute();
        if (n == -5) {
            switch (n10) {
                case 0: {
                    throw new HitException(7, "Eingabe f\u00fcr Datum fehlt");
                }
                case 1: 
                case 2: {
                    long l = (long)n7 * 86400000L;
                    Date date3 = new Date(date2.getTime() - l);
                    n7 = date3.getDate();
                    n8 = date3.getMonth() + 1;
                    n9 = date3.getYear() + 1900;
                    n5 = 1;
                    break;
                }
                case 3: {
                    n8 = date2.getMonth() + 1;
                    n9 = date2.getYear() + 1900;
                    if (n7 > date2.getDate()) {
                        if (n8 > 1) {
                            --n8;
                        } else {
                            n8 = 12;
                            --n9;
                        }
                        n5 = 2;
                        break;
                    }
                    n5 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    n9 = date2.getYear() + 1900;
                    n2 = date2.getMonth() + 1;
                    if (n8 > n2 || n8 == n2 && n7 > date2.getDate()) {
                        --n9;
                        n5 = 4;
                        break;
                    }
                    n5 = 5;
                }
            }
        } else {
            switch (n10) {
                case 0: {
                    throw new HitException(7, "Eingabe f\u00fcr Datum fehlt");
                }
                case 1: 
                case 2: 
                case 3: {
                    throw new HitException(7, "Eingabe f\u00fcr Datum unvollst\u00e4ndig");
                }
                case 4: 
                case 5: 
                case 6: {
                    if (n == -6) {
                        n9 = date2.getYear() + 1900;
                        n5 = 5;
                        break;
                    }
                    if (n == -7 || n == -9) {
                        n9 = date2.getYear() + 1900;
                        n4 = date2.getMonth() + 1;
                        if (n8 > n4 || n8 == n4 && n7 > date2.getDate()) {
                            --n9;
                            n5 = 4;
                            break;
                        }
                        n5 = 5;
                        break;
                    }
                    throw new HitException(7, "Beim Datum fehlt das Jahr");
                }
            }
        }
        switch (n) {
            case -2: {
                break;
            }
            case -6: 
            case -3: {
                if (n9 < 0 || n9 >= 100) break;
                n9 = date2.getYear() >= 100 ? (n9 += 2000) : (n9 += 1900);
                n5 = 7;
                break;
            }
            case -9: 
            case -8: 
            case -7: 
            case -5: 
            case -4: {
                if (n9 < 0 || n9 >= 100) break;
                bl = true;
                n9 = date2.getYear() >= 100 ? (n9 += 2000) : (n9 += 1900);
                n4 = date2.getYear() + 1900;
                n3 = date2.getMonth() + 1;
                if (n9 > n4 || n9 == n4 && (n8 > n3 || n8 == n3 && n7 > date2.getDate())) {
                    n9 -= 100;
                    n5 = 6;
                    break;
                }
                n5 = 7;
                break;
            }
            default: {
                throw new HitException(7, "Systemfehler Fillup falsch");
            }
        }
        if (n7 < 1 || n7 > 31) {
            throw new HitException(7, "Falsche Tagesangabe");
        }
        if (n8 < 1 || n8 > 12) {
            throw new HitException(7, "Falsche Monatsangabe");
        }
        if (n9 < 1800 || n9 > 2100) {
            throw new HitException(7, "Falsche Jahresangabe");
        }
        switch (n8) {
            case 2: {
                if (n7 <= 29 && (HitSimpleDTS.sblnSchaltJahr(n9) || n7 <= 28)) break;
                throw new HitException(7, "Falsche Tagesangabe");
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                if (n7 <= 30) break;
                throw new HitException(7, "Falsche Tagesangabe");
            }
        }
        date.setDate(n7);
        date.setMonth(n8 - 1);
        date.setYear(n9 - 1900);
        if (bl && (n == -4 || n == -7 || n == -5) && date.getTime() > date2.getTime()) {
            throw new HitException(7, "Datum liegt in der Zukunft");
        }
        return n5;
    }

    public static final Time sobjStrToSqlTime(String string) throws HitException {
        Time time = new Time(0, 0, 0);
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".:/-");
            int n = Integer.valueOf(stringTokenizer.nextToken());
            int n2 = Integer.valueOf(stringTokenizer.nextToken());
            int n3 = Integer.valueOf(stringTokenizer.nextToken());
            time.setHours(n);
            time.setMinutes(n2);
            time.setSeconds(n3);
        }
        catch (Exception exception) {
            throw new HitException("Invalid Format in HitHelper.sobjStrToSqlTime <" + string + ">");
        }
        return time;
    }

    public static final String sstrFormatHitTime(String string, String string2) throws HitException {
        Object object;
        if (string2 == null) {
            throw new HitException("Format NULL in HitHelper.sstrFormatHitTime");
        }
        String string3 = null;
        Time time = new Time(0, 0, 0);
        try {
            object = new StringTokenizer(string, ".:/-");
            int n = Integer.valueOf(((StringTokenizer)object).nextToken());
            int n2 = Integer.valueOf(((StringTokenizer)object).nextToken());
            int n3 = Integer.valueOf(((StringTokenizer)object).nextToken());
            time.setHours(n);
            time.setMinutes(n2);
            time.setSeconds(n3);
        }
        catch (Exception exception) {
            time = null;
        }
        try {
            if (time != null) {
                object = new SimpleDateFormat(string2);
                string3 = ((DateFormat)object).format(time);
            }
        }
        catch (Exception exception) {
            throw new HitException("Invalid Format in HitHelper.sstrFormatHitTime <" + string + ">");
        }
        return string3;
    }

    public static final String _sstrToDb2String(Time time) {
        return HitSimpleDTS._sstrToDBxString(time, '.', '.');
    }

    public static final String _sstrToPostgreString(Time time) {
        return HitSimpleDTS._sstrToDBxString(time, ':', ':');
    }

    private static final String _sstrToDBxString(Time time, char c, char c2) {
        if (time == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("'");
        int n = time.getHours();
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n).append(c);
        n = time.getMinutes();
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n).append(c2);
        n = time.getSeconds();
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    public static final int sintStrToSqlTime(String string, Time time) throws HitException {
        boolean bl = false;
        string = string.trim();
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        block22: for (int i = 0; i < n && n5 < 9; ++i) {
            switch (string.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    switch (n5) {
                        case 0: {
                            n2 = string.charAt(i) - 48;
                            n5 = 1;
                            continue block22;
                        }
                        case 1: {
                            n2 = 10 * n2 + string.charAt(i) - 48;
                            n5 = 2;
                            continue block22;
                        }
                        case 2: 
                        case 3: {
                            n3 = string.charAt(i) - 48;
                            n5 = 4;
                            continue block22;
                        }
                        case 4: {
                            n3 = 10 * n3 + string.charAt(i) - 48;
                            n5 = 5;
                            continue block22;
                        }
                        case 5: 
                        case 6: {
                            n4 = string.charAt(i) - 48;
                            n5 = 7;
                            continue block22;
                        }
                        case 7: {
                            n4 = 10 * n4 + string.charAt(i) - 48;
                            n5 = 8;
                            continue block22;
                        }
                        case 8: {
                            throw new HitException(7, "Falsches Zeitformat");
                        }
                    }
                    continue block22;
                }
                case ' ': 
                case ',': 
                case '.': 
                case '/': 
                case ':': 
                case ';': {
                    switch (n5) {
                        case 1: 
                        case 2: {
                            n5 = 3;
                            continue block22;
                        }
                        case 4: 
                        case 5: {
                            n5 = 6;
                            continue block22;
                        }
                        case 3: 
                        case 6: {
                            throw new HitException(7, "Mehrere Trennzeichen hintereinander");
                        }
                    }
                    throw new HitException(7, "Falsches Trennzeichen");
                }
                default: {
                    throw new HitException(7, "Falsches Zeichen in Zeit");
                }
            }
        }
        switch (n5) {
            case 0: {
                throw new HitException(7, "Eingabe f\u00fcr Zeit fehlt");
            }
            case 1: 
            case 2: 
            case 3: {
                throw new HitException(7, "Eingabe f\u00fcr Zeit unvollst\u00e4ndig");
            }
        }
        if (n2 < 0 || n2 > 23) {
            throw new HitException(7, "Falsche Stundenangabe");
        }
        if (n3 < 0 || n3 > 59) {
            throw new HitException(7, "Falsche Minutenangabe");
        }
        if (n4 < 0 || n4 > 59) {
            throw new HitException(7, "Falsche Sekundenangabe");
        }
        time.setHours(n2);
        time.setMinutes(n3);
        time.setSeconds(n4);
        return n5;
    }

    public static long slngDaySinceBegin(Timestamp timestamp) {
        long l = -1L;
        if (timestamp != null) {
            long l2 = (long)timestamp.getTimezoneOffset() * 60000L;
            l = (timestamp.getTime() - l2) / 86400000L;
        }
        return l;
    }

    public static Date sobjTsToDate(Timestamp timestamp, int n) {
        Date date = null;
        if (timestamp != null) {
            date = new Date(98, 0, 1);
            int n2 = timestamp.getDate();
            if (n == 2) {
                if (timestamp.getHours() > 0 || timestamp.getMinutes() > 0 || timestamp.getSeconds() > 0 || timestamp.getNanos() > 0) {
                    ++n2;
                }
            } else if (n == 1 && timestamp.getHours() >= 12) {
                ++n2;
            }
            date.setDate(n2);
            date.setMonth(timestamp.getMonth());
            date.setYear(timestamp.getYear());
        }
        return date;
    }

    public static Timestamp sobjDateToTs(Date date) {
        return HitSimpleDTS.sobjDateToTs(date, 0, 0, 0, 0);
    }

    public static Timestamp sobjDateToTs(Date date, int n, int n2, int n3, int n4) {
        Timestamp timestamp = new Timestamp(date.getYear(), date.getMonth(), date.getDate(), n, n2, n3, n4 * 1000);
        Date date2 = HitSimpleDTS.sobjTsToDate(timestamp, 0);
        if (!HitSimpleDTS.sblnEquals(date2, date)) {
            System.err.print("Date:");
            System.err.println(date);
            System.err.print("Year:");
            System.err.println(date.getYear());
            System.err.print("Mon :");
            System.err.println(date.getMonth());
            System.err.print("Date:");
            System.err.println(date.getDate());
            System.err.print("Day :");
            System.err.println(date.getDay());
            System.err.print("TS  :");
            System.err.println(timestamp);
            System.err.print("Dat2:");
            System.err.println(date2);
            System.err.print("Year:");
            System.err.println(date2.getYear());
            System.err.print("Mon :");
            System.err.println(date2.getMonth());
            System.err.print("Date:");
            System.err.println(date2.getDate());
            System.err.print("Day :");
            System.err.println(date2.getDay());
            throw new NullPointerException();
        }
        return timestamp;
    }

    public static final Timestamp sobjStrToSqlTS(String string) throws HitException {
        Timestamp timestamp = new Timestamp(98, 0, 1, 0, 0, 0, 0);
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".:/ ");
            int n = Integer.valueOf(stringTokenizer.nextToken());
            int n2 = Integer.valueOf(stringTokenizer.nextToken());
            int n3 = Integer.valueOf(stringTokenizer.nextToken());
            int n4 = Integer.valueOf(stringTokenizer.nextToken());
            int n5 = Integer.valueOf(stringTokenizer.nextToken());
            int n6 = Integer.valueOf(stringTokenizer.nextToken());
            int n7 = Integer.valueOf(stringTokenizer.nextToken());
            timestamp.setDate(n);
            timestamp.setMonth(n2 - 1);
            timestamp.setYear(n3 - 1900);
            timestamp.setHours(n4);
            timestamp.setMinutes(n5);
            timestamp.setSeconds(n6);
            timestamp.setNanos(n7 * 1000);
        }
        catch (Exception exception) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "-.:/ ");
                int n = Integer.valueOf(stringTokenizer.nextToken());
                int n8 = Integer.valueOf(stringTokenizer.nextToken());
                int n9 = Integer.valueOf(stringTokenizer.nextToken());
                int n10 = Integer.valueOf(stringTokenizer.nextToken());
                int n11 = Integer.valueOf(stringTokenizer.nextToken());
                int n12 = Integer.valueOf(stringTokenizer.nextToken());
                int n13 = Integer.valueOf(stringTokenizer.nextToken());
                timestamp.setDate(n9);
                timestamp.setMonth(n8 - 1);
                timestamp.setYear(n - 1900);
                timestamp.setHours(n10);
                timestamp.setMinutes(n11);
                timestamp.setSeconds(n12);
                timestamp.setNanos(n13 * 1000);
            }
            catch (Exception exception2) {
                throw new HitException("Invalid Format in HitHelper.sobjStrToSqlTS <" + string + ">, erwarte vollen Timestamp incl. Micros");
            }
        }
        return timestamp;
    }

    public static final int sintStrToSqlTimeStamp(String string, Timestamp timestamp) throws HitException {
        boolean bl = false;
        return HitSimpleDTS.sintStrToSqlTimeStamp(string, timestamp, 0, bl);
    }

    public static final int sintStrToSqlTimeStamp(String string, Timestamp timestamp, boolean bl) throws HitException {
        return HitSimpleDTS.sintStrToSqlTimeStamp(string, timestamp, 0, bl);
    }

    public static final Timestamp sobjStrToSqlTimeStamp(String string, boolean bl) throws HitException {
        Timestamp timestamp = new Timestamp(0L);
        int n = HitSimpleDTS.sintStrToSqlTimeStamp(string, timestamp, 0, bl);
        return timestamp;
    }

    public static final int sintStrToSqlTimeStamp(String string, Timestamp timestamp, int n, boolean bl) throws HitException {
        int n2;
        string = HitSimpleDTS.sstrTimestampDb2ToStd(string);
        int n3 = 0;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = n == 0 ? "0" : "23";
        String string6 = n == 0 ? "0" : "59";
        String string7 = n == 0 ? "0" : "59";
        String string8 = n == 0 ? "0" : "999999";
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = n == 0 ? 0 : 23;
        int n8 = n == 0 ? 0 : 59;
        int n9 = n == 0 ? 0 : 59;
        int n10 = n == 0 ? 0 : 999999;
        int n11 = string.indexOf(42);
        if (n11 > 0) {
            string = string.substring(0, n11);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ".:/ ");
        try {
            string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                if (string2.equalsIgnoreCase("offen") || string2.equalsIgnoreCase("ende")) {
                    string2 = "31";
                    string3 = "12";
                    string4 = "2100";
                }
            } else {
                string3 = stringTokenizer.nextToken();
                string4 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    string5 = stringTokenizer.nextToken();
                    if (stringTokenizer.hasMoreTokens()) {
                        string6 = stringTokenizer.nextToken();
                        if (stringTokenizer.hasMoreTokens()) {
                            string7 = stringTokenizer.nextToken();
                        } else {
                            n3 = 10;
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            string8 = stringTokenizer.nextToken();
                        } else {
                            n3 = 11;
                        }
                    } else {
                        n3 = 9;
                    }
                } else {
                    n3 = 8;
                }
            }
        }
        catch (Exception exception) {
            throw new HitException(7, "Nicht im Format TT.MM.JJJJ/HH.NN.SS[.XXXXXX]");
        }
        try {
            n4 = HitHelpers.sobjInteger(string2);
        }
        catch (Exception exception) {
            throw new HitException(7, "Fehler bei Tag");
        }
        try {
            n5 = HitHelpers.sobjInteger(string3);
        }
        catch (Exception exception) {
            throw new HitException(7, "Fehler bei Monat");
        }
        try {
            n6 = HitHelpers.sobjInteger(string4);
        }
        catch (Exception exception) {
            throw new HitException(7, "Fehler bei Jahr");
        }
        try {
            n7 = HitHelpers.sobjInteger(string5);
        }
        catch (Exception exception) {
            throw new HitException(7, "Fehler bei Stunde");
        }
        try {
            n8 = HitHelpers.sobjInteger(string6);
        }
        catch (Exception exception) {
            throw new HitException(7, "Fehler bei Minute");
        }
        try {
            n9 = HitHelpers.sobjInteger(string7);
        }
        catch (Exception exception) {
            throw new HitException(7, "Fehler bei Sekunde");
        }
        try {
            if (bl && (n2 = string8.length()) < 6) {
                string8 = string8 + "000000".subSequence(0, 6 - n2);
            }
            n10 = HitHelpers.sobjInteger(string8);
        }
        catch (Exception exception) {
            throw new HitException(7, "Fehler bei Mikro");
        }
        if (stringTokenizer.hasMoreTokens()) {
            throw new HitException(7, "Nicht im Format TT.MM.JJJJ/HH.NN.SS[.XXXXXX]");
        }
        if (n4 < 1 || n4 > 31 || string2.length() > 2) {
            throw new HitException(7, "Falsche Tagesangabe");
        }
        if (string3 == null || n5 < 1 || n5 > 12 || string3.length() > 2) {
            throw new HitException(7, "Falsche Monatsangabe");
        }
        if (string4 == null || n6 >= 0 && n6 <= 99 || string4.length() > 4) {
            n6 += 2000;
            n3 = 7;
        }
        if (n6 < 1800 || n6 > 2100) {
            throw new HitException(7, "Falsche Jahresangabe");
        }
        switch (n5) {
            case 2: {
                if (n4 <= 29 && (HitSimpleDTS.sblnSchaltJahr(n6) || n4 <= 28)) break;
                throw new HitException(7, "Falsche Tagesangabe");
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                if (n4 <= 30) break;
                throw new HitException(7, "Falsche Tagesangabe");
            }
        }
        if (n7 == 24 && n8 == 0 && n9 == 0 && n10 == 0) {
            n7 = 0;
            int n12 = n2 = HitSimpleDTS.sblnSchaltJahr(n6) ? 1 : 0;
            if (++n4 > caaintMonatstage[n2][n5 - 1]) {
                n4 = 1;
                if (++n5 > 12) {
                    n5 = 1;
                    ++n6;
                }
            }
            n3 = 99;
        }
        if (n7 < 0 || n7 > 23 || string5.length() > 2) {
            throw new HitException(7, "Falsche Stundenangabe");
        }
        if (n8 < 0 || n8 > 59 || string6.length() > 2) {
            throw new HitException(7, "Falsche Minutenangabe");
        }
        if (n9 < 0 || n9 > 59 || string7.length() > 2) {
            throw new HitException(7, "Falsche Sekundenangabe");
        }
        if (n10 < 0 || n10 > 999999 || string8.length() > 6) {
            throw new HitException(7, "Falsche Mikrosekundenangabe");
        }
        timestamp.setDate(n4);
        timestamp.setMonth(n5 - 1);
        timestamp.setYear(n6 - 1900);
        timestamp.setHours(n7);
        timestamp.setMinutes(n8);
        timestamp.setSeconds(n9);
        timestamp.setNanos(n10 * 1000);
        return n3;
    }

    public static final String sstrFormatHitTS(String string, String string2) throws HitException {
        if (string2 == null) {
            throw new HitException("Format NULL in HitHelper.sstrFormatHitTS");
        }
        String string3 = null;
        if (string != null) {
            Timestamp timestamp = new Timestamp(98, 0, 1, 0, 0, 0, 0);
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".:/ ");
                String string4 = stringTokenizer.nextToken();
                int n = Integer.valueOf(string4);
                string4 = stringTokenizer.nextToken();
                int n2 = Integer.valueOf(string4);
                string4 = stringTokenizer.nextToken();
                int n3 = Integer.valueOf(string4);
                string4 = stringTokenizer.nextToken();
                int n4 = Integer.valueOf(string4);
                string4 = stringTokenizer.nextToken();
                int n5 = Integer.valueOf(string4);
                string4 = stringTokenizer.nextToken();
                int n6 = Integer.valueOf(string4);
                string4 = HitSimpleDTS.sstrMikroPad0(stringTokenizer.nextToken());
                int n7 = Integer.valueOf(string4);
                timestamp.setDate(n);
                timestamp.setMonth(n2 - 1);
                timestamp.setYear(n3 - 1900);
                timestamp.setHours(n4);
                timestamp.setMinutes(n5);
                timestamp.setSeconds(n6);
                timestamp.setNanos(n7 * 1000);
            }
            catch (Exception exception) {
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "-.:/ ");
                    String string5 = stringTokenizer.nextToken();
                    int n = Integer.valueOf(string5);
                    string5 = stringTokenizer.nextToken();
                    int n8 = Integer.valueOf(string5);
                    string5 = stringTokenizer.nextToken();
                    int n9 = Integer.valueOf(string5);
                    string5 = stringTokenizer.nextToken();
                    int n10 = Integer.valueOf(string5);
                    string5 = stringTokenizer.nextToken();
                    int n11 = Integer.valueOf(string5);
                    string5 = stringTokenizer.nextToken();
                    int n12 = Integer.valueOf(string5);
                    string5 = HitSimpleDTS.sstrMikroPad0(stringTokenizer.nextToken());
                    int n13 = Integer.valueOf(string5);
                    timestamp.setDate(n9);
                    timestamp.setMonth(n8 - 1);
                    timestamp.setYear(n - 1900);
                    timestamp.setHours(n10);
                    timestamp.setMinutes(n11);
                    timestamp.setSeconds(n12);
                    timestamp.setNanos(n13 * 1000);
                }
                catch (Exception exception2) {
                    timestamp = null;
                }
            }
            string3 = HitSimpleDTS.sstrFormatHitTS(timestamp, string2);
        }
        return string3;
    }

    public static String sstrFormatHitTS(Timestamp timestamp, String string) throws HitException {
        String string2 = null;
        try {
            if (timestamp != null) {
                Serializable serializable;
                int n = string.indexOf(83);
                if (n >= 0) {
                    serializable = new StringBuffer("0");
                    int n2 = 1;
                    int n3 = string.length();
                    for (int i = n + 1; i < n3 && string.charAt(i) == 'S'; ++i) {
                        ((StringBuffer)serializable).append('0');
                        ++n2;
                    }
                    String string3 = string.substring(n, n + n2);
                    DecimalFormat decimalFormat = new DecimalFormat(((StringBuffer)serializable).toString());
                    int n4 = timestamp.getNanos() / 1000;
                    String string4 = decimalFormat.format(n4);
                    string = HitHelpers.sstrTranslate(string, string3, string4);
                }
                serializable = new SimpleDateFormat(string);
                string2 = ((DateFormat)serializable).format(timestamp);
            }
        }
        catch (Exception exception) {
            throw new HitException("Invalid Format in HitHelper.sstrFormatHitTS <" + string + ">");
        }
        return string2;
    }

    public static final String sstrMikroPad0(String string) {
        int n = string.length();
        if (n < 6 && n >= 0) {
            string = string + "000000".substring(n);
        }
        return string;
    }

    public static final String sstrToString(Timestamp timestamp) {
        return HitSimpleDTS.sstrToString(timestamp, 1);
    }

    public static final String sstrToStringMilliExact(Timestamp timestamp) {
        return HitSimpleDTS.sstrToString(timestamp, 2);
    }

    public static final String sstrToStringDate(Timestamp timestamp) {
        return HitSimpleDTS.sstrToString(timestamp, 3);
    }

    public static final String sstrToString(Timestamp timestamp, int n) {
        if (timestamp == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(27);
        int n2 = timestamp.getDate();
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2).append('.');
        n2 = timestamp.getMonth() + 1;
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2).append('.');
        n2 = timestamp.getYear() + 1900;
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        if (n == 3) {
            stringBuffer.append(n2);
        } else {
            stringBuffer.append(n2).append('/');
            n2 = timestamp.getHours();
            if (n2 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n2).append('.');
            n2 = timestamp.getMinutes();
            if (n2 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n2);
            if (n != 4) {
                stringBuffer.append('.');
                n2 = timestamp.getSeconds();
                if (n2 < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n2).append('.');
                n2 = timestamp.getNanos() / 1000;
                if (n == 1) {
                    stringBuffer.append(n2);
                } else if (n == 2) {
                    if (n2 < 10) {
                        stringBuffer.append("00000");
                    } else if (n2 < 100) {
                        stringBuffer.append("0000");
                    } else if (n2 < 1000) {
                        stringBuffer.append("000");
                    } else if (n2 < 10000) {
                        stringBuffer.append("00");
                    } else if (n2 < 100000) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n2);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static final String sstrDateDb2ToStd(String string) {
        int n;
        if (string == null || string.length() != 10 || string.charAt(4) != '-' || string.charAt(7) != '-') {
            return string;
        }
        for (n = 0; n <= 3; ++n) {
            if (Character.isDigit(string.charAt(n))) continue;
            return string;
        }
        for (n = 5; n <= 6; ++n) {
            if (Character.isDigit(string.charAt(n))) continue;
            return string;
        }
        for (n = 8; n <= 9; ++n) {
            if (Character.isDigit(string.charAt(n))) continue;
            return string;
        }
        return string.substring(8, 10) + '.' + string.substring(5, 7) + '.' + string.substring(0, 4);
    }

    public static final String sstrTimestampDb2ToStd(String string) {
        int n;
        int n2;
        int n3 = n2 = string == null ? 0 : string.length();
        if (string == null || n2 < 19 || string.charAt(4) != '-' || string.charAt(7) != '-' || string.charAt(10) != ' ' && string.charAt(10) != '-' || string.charAt(13) != '.' && string.charAt(13) != ':' || string.charAt(16) != '.' && string.charAt(16) != ':' || n2 > 19 && string.charAt(19) != '.') {
            return string;
        }
        for (n = 0; n <= 3; ++n) {
            if (Character.isDigit(string.charAt(n))) continue;
            return string;
        }
        for (n = 5; n <= 6; ++n) {
            if (Character.isDigit(string.charAt(n))) continue;
            return string;
        }
        for (n = 8; n <= 9; ++n) {
            if (Character.isDigit(string.charAt(n))) continue;
            return string;
        }
        for (n = 11; n <= 12; ++n) {
            if (Character.isDigit(string.charAt(n))) continue;
            return string;
        }
        for (n = 14; n <= 15; ++n) {
            if (Character.isDigit(string.charAt(n))) continue;
            return string;
        }
        for (n = 17; n <= 18; ++n) {
            if (Character.isDigit(string.charAt(n))) continue;
            return string;
        }
        for (n = 20; n < n2; ++n) {
            if (Character.isDigit(string.charAt(n))) continue;
            return string;
        }
        return string.substring(8, 10) + '.' + string.substring(5, 7) + '.' + string.substring(0, 4) + '/' + string.substring(11);
    }

    public static final String sstrDateDb2ToStdX(String string) {
        int n;
        if (string != null && (n = string.length()) == 12 && string.charAt(0) == '\'' && string.charAt(n - 1) == '\'') {
            return HitSimpleDTS.sstrDateDb2ToStd(string.substring(1, n - 1));
        }
        return HitSimpleDTS.sstrDateDb2ToStd(string);
    }

    public static final String sstrTimestampDb2ToStdX(String string) {
        int n;
        if (string != null && (n = string.length()) >= 12 && string.charAt(0) == '\'' && string.charAt(n - 1) == '\'') {
            return HitSimpleDTS.sstrTimestampDb2ToStd(string.substring(1, n - 1));
        }
        return HitSimpleDTS.sstrTimestampDb2ToStd(string);
    }

    public static final String sstrTimeDb2ToStdX(String string) {
        int n;
        if (string != null && (n = string.length()) >= 4 && string.charAt(0) == '\'' && string.charAt(n - 1) == '\'') {
            return string.substring(1, n - 1);
        }
        return string;
    }

    public static final String _sstrToDb2String(Timestamp timestamp) {
        return HitSimpleDTS._sstrToDBxString(timestamp, '-', '-', '-', '.', '.', '.');
    }

    public static final String _sstrToPostgreString(Timestamp timestamp) {
        return HitSimpleDTS._sstrToDBxString(timestamp, '-', '-', ' ', ':', ':', '.');
    }

    private static final String _sstrToDBxString(Timestamp timestamp, char c, char c2, char c3, char c4, char c5, char c6) {
        if (timestamp == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("'");
        int n = timestamp.getYear() + 1900;
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n).append(c);
        n = timestamp.getMonth() + 1;
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n).append(c2);
        n = timestamp.getDate();
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n).append(c3);
        n = timestamp.getHours();
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n).append(c4);
        n = timestamp.getMinutes();
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n).append(c5);
        n = timestamp.getSeconds();
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n).append(c6);
        n = timestamp.getNanos() / 1000;
        if (n < 10) {
            stringBuffer.append("00000");
        } else if (n < 100) {
            stringBuffer.append("0000");
        } else if (n < 1000) {
            stringBuffer.append("000");
        } else if (n < 10000) {
            stringBuffer.append("00");
        } else if (n < 100000) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n).append('\'');
        return stringBuffer.toString();
    }

    public static final boolean sblnSchaltJahr(int n) {
        return n % 4 == 0 && n % 100 != 0 || n % 400 == 0;
    }

    public static final int sintGetHeuer() {
        return HitSimpleDTS.sobjSqlDateHeute().getYear() + 1900;
    }

    public static final int sintGetWochentag(String string) {
        int n;
        if (string.length() > 2) {
            string = string.substring(0, 2);
        }
        for (n = 6; n >= 0 && !csastrWochentage[n].equalsIgnoreCase(string); --n) {
        }
        return n;
    }

    public static final String sstrToString(Time time) {
        if (time == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(12);
        int n = time.getHours();
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n).append('.');
        n = time.getMinutes();
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n).append('.');
        n = time.getSeconds();
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
        return stringBuffer.toString();
    }

    public static final boolean sblnTsIsInIntervall(Timestamp timestamp, Timestamp timestamp2, Timestamp timestamp3) {
        if (timestamp == null || timestamp2 == null || timestamp3 == null) {
            return true;
        }
        if (timestamp.before(timestamp2)) {
            return false;
        }
        return timestamp.before(timestamp3);
    }

    public static int sintGetResulution(Timestamp timestamp) {
        int n = 0;
        if (timestamp != null) {
            n = timestamp.getNanos() > 0 ? 5 : (timestamp.getSeconds() > 0 ? 4 : (timestamp.getMinutes() > 0 ? 3 : (timestamp.getHours() > 0 ? 2 : 1)));
        }
        return n;
    }

    public static String sstrFormatMilliDifferenz(long l, long l2) {
        return HitSimpleDTS.sstrFormatMilliDifferenz(l2 - l);
    }

    public static String sstrFormatMilliDifferenz(long l) {
        return HitSimpleDTS.sstrFormatMilliDifferenz(l, true);
    }

    public static String sstrFormatMilliDifferenz(long l, boolean bl) {
        String string = null;
        try {
            boolean bl2;
            boolean bl3 = bl2 = l < 0L;
            if (bl2) {
                l = -l;
            }
            String string2 = bl ? ".{0,number,000}" : "";
            String string3 = "0" + string2 + "s";
            int n = (int)(l % 1000L);
            if ((l /= 1000L) > 0L) {
                string3 = "{1,number,#}" + string2 + "s";
            }
            int n2 = (int)(l % 60L);
            if ((l /= 60L) > 0L) {
                string3 = "{2,number,#}m{1,number,00}" + string2 + "s";
            }
            int n3 = (int)(l % 60L);
            if ((l /= 60L) > 0L) {
                string3 = "{3,number,#}h{2,number,00}m{1,number,00}" + string2 + "s";
            }
            int n4 = (int)(l % 24L);
            if ((l /= 24L) > 0L) {
                string3 = "{4,number,#}d {3,number,00}h{2,number,00}m{1,number,00}" + string2 + "s";
            }
            string = (bl2 ? "-" : "") + new MessageFormat(string3).format(new Object[]{n, n2, n3, n4, new Long(l)});
        }
        catch (Exception exception) {
            string = "Sek?=" + exception.toString();
        }
        return string;
    }

    public static String sstrStripHK(String string) {
        int n;
        if (string != null && (n = string.length()) >= 4 && string.charAt(0) == '\'' && string.charAt(n - 1) == '\'') {
            return string.substring(1, n - 1);
        }
        return string;
    }
}

