/*
 * Decompiled with CFR 0.152.
 */
package HitUpros;

import HitUpros.LomCountryInterface;
import HitUpros.LomDate;
import HitUpros.LomEU;
import HitUpros.LomNumber;
import HitUpros.Lom_AT;
import HitUpros.Lom_BE;
import HitUpros.Lom_BG;
import HitUpros.Lom_CH;
import HitUpros.Lom_CY;
import HitUpros.Lom_CZ;
import HitUpros.Lom_DE;
import HitUpros.Lom_DK;
import HitUpros.Lom_DY;
import HitUpros.Lom_EE;
import HitUpros.Lom_EL;
import HitUpros.Lom_ES;
import HitUpros.Lom_FI;
import HitUpros.Lom_FR;
import HitUpros.Lom_HR;
import HitUpros.Lom_HU;
import HitUpros.Lom_IE;
import HitUpros.Lom_IT;
import HitUpros.Lom_LT;
import HitUpros.Lom_LU;
import HitUpros.Lom_LV;
import HitUpros.Lom_MT;
import HitUpros.Lom_NL;
import HitUpros.Lom_PL;
import HitUpros.Lom_PT;
import HitUpros.Lom_RO;
import HitUpros.Lom_SE;
import HitUpros.Lom_SI;
import HitUpros.Lom_SK;
import HitUpros.Lom_UK;
import java.math.BigInteger;
import java.sql.Date;
import java.util.Vector;

public final class LomCoder2 {
    public static final String sstrVersion = "LomCoder Version 42 (10-Jul-2013)";
    public static final Date scobjDateNoSerCheck = new Date(200, 11, 31);
    public static final int scintNICHT_EU = 0;
    public static final int scintIST_EU = 1;
    public static final int scintVIELLEICHT_EU = 2;
    private static Vector objThisCountries = null;

    private static void initCountries() {
        if (objThisCountries != null) {
            return;
        }
        objThisCountries = new Vector();
        objThisCountries.addElement(new Lom_AT());
        objThisCountries.addElement(new Lom_BE());
        objThisCountries.addElement(new Lom_DK());
        objThisCountries.addElement(new Lom_FI());
        objThisCountries.addElement(new Lom_FR());
        objThisCountries.addElement(new Lom_EL());
        objThisCountries.addElement(new Lom_IE());
        objThisCountries.addElement(new Lom_IT());
        objThisCountries.addElement(new Lom_LU());
        objThisCountries.addElement(new Lom_NL());
        objThisCountries.addElement(new Lom_PT());
        objThisCountries.addElement(new Lom_ES());
        objThisCountries.addElement(new Lom_SE());
        objThisCountries.addElement(new Lom_UK());
        objThisCountries.addElement(new Lom_DY());
        objThisCountries.addElement(new Lom_CY());
        objThisCountries.addElement(new Lom_CZ());
        objThisCountries.addElement(new Lom_EE());
        objThisCountries.addElement(new Lom_HU());
        objThisCountries.addElement(new Lom_LV());
        objThisCountries.addElement(new Lom_LT());
        objThisCountries.addElement(new Lom_MT());
        objThisCountries.addElement(new Lom_PL());
        objThisCountries.addElement(new Lom_SK());
        objThisCountries.addElement(new Lom_SI());
        objThisCountries.addElement(new Lom_BG());
        objThisCountries.addElement(new Lom_RO());
        objThisCountries.addElement(new Lom_CH());
        objThisCountries.addElement(new Lom_HR());
        objThisCountries.addElement(new Lom_DE());
    }

    public static int sintEncodeLom(String string, LomNumber lomNumber) {
        return LomCoder2.sintEncodeLom(string, lomNumber, LomDate.NOT_SET);
    }

    public static int sintEncodeLom(String string, LomNumber lomNumber, Date date) {
        LomCountryInterface lomCountryInterface;
        LomCoder2.initCountries();
        lomNumber.setVersion(sstrVersion);
        if (string.toLowerCase().equals("v?")) {
            lomNumber.set(new BigInteger("0"));
            return 0;
        }
        try {
            Long.parseLong(string);
            if (string.length() != 10) {
                throw new Exception();
            }
            string = "DE" + string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = -5;
        for (int i = 0; i < objThisCountries.size() && (n = (lomCountryInterface = (LomCountryInterface)objThisCountries.elementAt(i)).encodeLom(string, lomNumber, date)) == -5; ++i) {
        }
        return n;
    }

    public static String sstrToString(LomNumber lomNumber) {
        return LomEU.sstrToString(lomNumber);
    }

    public static String sstrToFormattedString(LomNumber lomNumber) {
        LomCountryInterface lomCountryInterface;
        LomCoder2.initCountries();
        String string = null;
        for (int i = 0; i < objThisCountries.size() && (string = (lomCountryInterface = (LomCountryInterface)objThisCountries.elementAt(i)).decodeLom(lomNumber)) == null; ++i) {
        }
        return string == null ? "#" + LomCoder2.sstrToString(lomNumber) : string;
    }

    public static String sstrDecodeLom(LomNumber lomNumber) {
        return LomCoder2.sstrToFormattedString(lomNumber);
    }

    public static int sintAlphaToCode(String string) {
        LomCountryInterface lomCountryInterface;
        LomCoder2.initCountries();
        int n = -1;
        for (int i = 0; i < objThisCountries.size() && (n = (lomCountryInterface = (LomCountryInterface)objThisCountries.elementAt(i)).getCountry_CodeFromAlpha(string)) == -5; ++i) {
        }
        return n;
    }

    public static String sstrCodeToAlpha(int n) {
        LomCountryInterface lomCountryInterface;
        LomCoder2.initCountries();
        String string = null;
        for (int i = 0; i < objThisCountries.size() && (string = (lomCountryInterface = (LomCountryInterface)objThisCountries.elementAt(i)).getCountry_AlphaFromCode(n)) == null; ++i) {
        }
        return string == null ? "<unbekannt>" : string;
    }

    public static int sintIsEU(int n, Date date) {
        LomCoder2.initCountries();
        for (int i = 0; i < objThisCountries.size(); ++i) {
            LomCountryInterface lomCountryInterface = (LomCountryInterface)objThisCountries.elementAt(i);
            if (n != lomCountryInterface.getCountryCode()) continue;
            return lomCountryInterface.isCountryEU(date);
        }
        return 0;
    }

    public static int sintIsEU(int n) {
        return LomCoder2.sintIsEU(n, LomDate.NOT_SET);
    }
}

