/*
 * Decompiled with CFR 0.152.
 */
package HitUpros;

import HitUpros.LomCoder2;
import HitUpros.LomCoderErrors;
import HitUpros.LomCountryInterface;
import HitUpros.LomDate;
import HitUpros.LomNumber;
import java.math.BigInteger;
import java.sql.Date;

public abstract class LomEU
implements LomCountryInterface {
    protected int intThisCountryIsoCode = 0;
    protected String strThisCountryIsoId = "??";
    protected int intThisCountryHIT = 0;
    protected Date objThisValidDateBegin = LomDate.NOT_SET;
    public static Date scobjDate01011900 = new Date(0, 0, 1);
    public static Date scobjDate28101995 = new Date(95, 9, 28);
    public static Date scobjDate31121997 = new Date(97, 11, 31);
    public static Date scobjDate01011998 = new Date(98, 0, 1);
    public static Date scobjDate31121999 = new Date(99, 11, 31);
    public static Date scobjDate01012000 = new Date(100, 0, 1);
    public static Date scobjDate31122100 = new Date(200, 11, 31);
    public static Date scobjDate01052004 = new Date(104, 4, 1);
    public static Date scobjDate01012007 = new Date(107, 0, 1);
    public static Date scobjDate01072013 = new Date(113, 6, 1);
    public static Date scobjDateNoSerCheck = scobjDate31122100;
    public static final int NICHT_GUELTIG = 0;
    public static final int IST_GUELTIG = 1;
    public static final int VIELLEICHT_GUELTIG = 2;
    protected static final int NICHT_EU = 0;
    protected static final int IST_EU = 1;
    protected static final int VIELLEICHT_EU = 2;

    protected void setCountryParameters(String string, int n) {
        this.setCountryParameters(string, n, n);
    }

    protected void setCountryParameters(String string, int n, int n2) {
        this.strThisCountryIsoId = string;
        this.intThisCountryIsoCode = n;
        this.intThisCountryHIT = n2;
    }

    @Override
    public int getCountryCode() {
        return this.intThisCountryIsoCode;
    }

    @Override
    public String getCountryId() {
        return this.strThisCountryIsoId;
    }

    @Override
    public int getCountryHIT() {
        return this.intThisCountryHIT;
    }

    @Override
    public abstract int isCountryEU(Date var1);

    protected int isValidEULom(Date date) {
        switch (this.isLomValidAt(date)) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    protected void setLomValidFrom(Date date) {
        this.objThisValidDateBegin = date;
    }

    public int isLomValidAt(Date date) {
        if (this.objThisValidDateBegin == LomDate.NOT_SET) {
            return 1;
        }
        if (date == LomDate.NOT_SET) {
            return 2;
        }
        return date.before(this.objThisValidDateBegin) ? 0 : 1;
    }

    @Override
    public int encodeLom(String string, LomNumber lomNumber, Date date) {
        CharSequence charSequence;
        if (string.charAt(0) == '#' && string.length() > 1) {
            string = string.substring(1);
            try {
                Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                return -9;
            }
            lomNumber.set(new BigInteger(string));
            return 0;
        }
        int n = 0;
        if (string == null || string.length() < 3) {
            return -1;
        }
        int n2 = 0;
        switch (this.isLomValidAt(date)) {
            case 1: {
                break;
            }
            case 0: {
                return -5;
            }
            case 2: {
                n2 = -16;
            }
        }
        boolean bl = true;
        try {
            Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        if (bl && (string.length() == 14 || string.length() == 15) && (charSequence = this.decodeLom(new LomNumber(string))) != null && !((String)charSequence).startsWith("#")) {
            lomNumber.set(new BigInteger(string));
            return n2;
        }
        charSequence = new StringBuffer("");
        block12: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                ((StringBuffer)charSequence).append(c);
                continue;
            }
            switch (c) {
                case ' ': 
                case '-': 
                case '.': {
                    continue block12;
                }
                default: {
                    return -11;
                }
            }
        }
        string = ((StringBuffer)charSequence).toString().toUpperCase();
        String string2 = this.getRelevantDigitsForCountry(string);
        if (string2 == null) {
            return -5;
        }
        n = this.encodeLomDigits(string2, lomNumber, date);
        return n == 0 ? n2 : n;
    }

    protected abstract int encodeLomDigits(String var1, LomNumber var2, Date var3);

    @Override
    public String decodeLom(LomNumber lomNumber) {
        if (!this.isCountryOf(lomNumber)) {
            return null;
        }
        String string = this.decodeLomDigits(lomNumber);
        if (string.charAt(0) == '#') {
            return string;
        }
        LomNumber lomNumber2 = new LomNumber();
        int n = this.encodeLom(string, lomNumber2, LomCoder2.scobjDateNoSerCheck);
        if (LomCoderErrors.sintGetFehlerSchwere(n) < 2 && lomNumber2.isEqual(lomNumber)) {
            return string;
        }
        return "#" + LomEU.sstrToString(lomNumber);
    }

    protected abstract String decodeLomDigits(LomNumber var1);

    public static String sstrToString(LomNumber lomNumber) {
        return lomNumber.getLom();
    }

    public abstract boolean hasCheckdigit();

    public boolean isSameCountryAs(String string) {
        return string.equalsIgnoreCase(this.getCountryId());
    }

    public boolean isSameCountryAs(int n) {
        return n == this.getCountryCode();
    }

    public boolean isCountryOf(LomNumber lomNumber) {
        boolean bl;
        int n = lomNumber.getCountry();
        boolean bl2 = bl = n == this.getCountryCode();
        if (this.getCountryCode() == this.getCountryHIT()) {
            return bl;
        }
        if (bl) {
            return true;
        }
        bl = n == this.getCountryHIT();
        return bl;
    }

    @Override
    public int getCountry_CodeFromAlpha(String string) {
        if (this.isSameCountryAs(string)) {
            return this.getCountryCode();
        }
        return -5;
    }

    @Override
    public String getCountry_AlphaFromCode(int n) {
        if (this.isSameCountryAs(n)) {
            return this.getCountryId();
        }
        return null;
    }

    protected String getRelevantDigitsForCountry(String string) {
        return this.getRelevantDigitsForCountry(string, this.getCountryId(), this.getCountryCode(), this.getCountryHIT());
    }

    protected String getRelevantDigitsForCountry(String string, String string2, int n, int n2) {
        String string3 = string.substring(0, 2);
        int n3 = string3.equals(string2) ? n : -1;
        String string4 = string.substring(2);
        if (n3 < 0) {
            try {
                n3 = Integer.parseInt(string.substring(0, 2));
                string4 = string.substring(2);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            if (n3 == n2 && n != n2) {
                return null;
            }
            int n4 = n3 = n3 == n ? n : -1;
            if (n3 < 0) {
                try {
                    n3 = Integer.parseInt(string.substring(0, 3));
                    string4 = string.substring(3);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
                catch (Exception exception) {
                    return null;
                }
                if (n3 == n2 && n != n2) {
                    return null;
                }
                int n5 = n3 = n3 == n ? n : -1;
                if (n3 < 0) {
                    if (n == 276 && string.length() <= 12) {
                        n3 = 276;
                        string4 = string;
                    } else {
                        return null;
                    }
                }
            }
        }
        return string4;
    }

    protected int pruefeLomLaenge(String string, int n) {
        if (string == null || string.length() == 0) {
            return -9;
        }
        int n2 = 0;
        while (string.length() > n2 && string.charAt(n2++) == '0') {
        }
        --n2;
        boolean bl = false;
        try {
            Long.parseLong(string);
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int n3 = string.length();
        if (n3 == 12 && bl && n <= 12) {
            if (12 - n2 > n) {
                return -3;
            }
            return 0;
        }
        if (n3 < n) {
            return -2;
        }
        if (n3 > n) {
            return -3;
        }
        return 0;
    }

    protected int pruefeLomLaenge(String string, int n, int n2) {
        int n3;
        if (n > n2) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        if ((n3 = this.pruefeLomLaenge(string, n)) != 0 && (n3 = this.pruefeLomLaenge(string, n2)) == -2) {
            n3 = -4;
        }
        return n3;
    }

    protected int pruefeLomLaenge(String string, int n, int n2, int n3) {
        int n4;
        int n5;
        if (n > n2) {
            n5 = n;
            n = n2;
            n2 = n5;
        }
        if (n > n3) {
            n5 = n;
            n = n3;
            n3 = n5;
        }
        if (n2 > n3) {
            n5 = n2;
            n2 = n3;
            n3 = n5;
        }
        if ((n4 = this.pruefeLomLaenge(string, n)) != 0 && (n4 = this.pruefeLomLaenge(string, n2)) != 0 && (n4 = this.pruefeLomLaenge(string, n3)) == -2) {
            n4 = -4;
        }
        return n4;
    }

    protected boolean objBaueLom(LomNumber lomNumber, String string, int n) {
        try {
            Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        BigInteger bigInteger = new BigInteger(string);
        bigInteger = bigInteger.add(new BigInteger(n + "000000000000"));
        lomNumber.set(bigInteger);
        return true;
    }
}

