/*
 * Decompiled with CFR 0.152.
 */
package HitUpros;

import HitUpros.LomEU;
import HitUpros.LomNumber;
import java.sql.Date;

public final class Lom_HR
extends LomEU {
    public Lom_HR() {
        this.setLomValidFrom(scobjDate01072013);
        this.setCountryParameters("HR", 191);
    }

    @Override
    public int isCountryEU(Date date) {
        return this.isValidEULom(date);
    }

    @Override
    protected int encodeLomDigits(String string, LomNumber lomNumber, Date date) {
        try {
            Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -9;
        }
        int n = this.pruefeLomLaenge(string, 10);
        if (n != 0) {
            return n;
        }
        String string2 = string.substring(string.length() - 10);
        int n2 = this.calcCheckdigitFor(string2);
        if (n2 < 0) {
            return n2;
        }
        int n3 = Integer.parseInt(string2.substring(0, 1));
        if (n3 != n2) {
            return -6;
        }
        if (!this.objBaueLom(lomNumber, string, this.getCountryCode())) {
            return -7;
        }
        return 0;
    }

    @Override
    protected String decodeLomDigits(LomNumber lomNumber) {
        String string = Lom_HR.sstrToString(lomNumber);
        String string2 = string.substring(3);
        return this.getCountryId() + " " + string2.substring(2, 3) + " " + string2.substring(3, 8) + " " + string2.substring(8, 12);
    }

    @Override
    public boolean hasCheckdigit() {
        return true;
    }

    private int calcCheckdigitFor(String string) {
        int n;
        if (string.length() != 10) {
            return -4;
        }
        int n2 = 0;
        try {
            n2 += 3 * Integer.parseInt(string.substring(1, 2));
            n2 += 7 * Integer.parseInt(string.substring(2, 3));
            n2 += 9 * Integer.parseInt(string.substring(3, 4));
            n2 += 11 * Integer.parseInt(string.substring(4, 5));
            n2 += 13 * Integer.parseInt(string.substring(5, 6));
            n2 += 17 * Integer.parseInt(string.substring(6, 7));
            n2 += 19 * Integer.parseInt(string.substring(7, 8));
            n2 += 21 * Integer.parseInt(string.substring(8, 9));
            n = (n2 += 23 * Integer.parseInt(string.substring(9, 10))) % 10;
        }
        catch (NumberFormatException numberFormatException) {
            return -7;
        }
        return n;
    }
}

