/*
 * Decompiled with CFR 0.152.
 */
package HitUpros;

import HitUpros.LomEU;
import HitUpros.LomNumber;
import java.sql.Date;

public final class Lom_SI
extends LomEU {
    public Lom_SI() {
        this.setLomValidFrom(scobjDate01052004);
        this.setCountryParameters("SI", 705);
    }

    @Override
    public int isCountryEU(Date date) {
        return this.isValidEULom(date);
    }

    @Override
    protected int encodeLomDigits(String string, LomNumber lomNumber, Date date) {
        try {
            Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -9;
        }
        int n = this.pruefeLomLaenge(string, 6, 7, 8);
        if (n != 0) {
            return n;
        }
        if (!this.objBaueLom(lomNumber, string, this.getCountryCode())) {
            return -7;
        }
        return 0;
    }

    @Override
    protected String decodeLomDigits(LomNumber lomNumber) {
        String string = Lom_SI.sstrToString(lomNumber);
        String string2 = string.substring(3);
        int n = this.calcCheckdigitFor(string2.substring(5, 12));
        if (n == Integer.parseInt(string2.substring(4, 5))) {
            return this.getCountryId() + " " + string2.substring(4, 8) + " " + string2.substring(8, 12);
        }
        return this.getCountryId() + " " + string2.substring(4, 12);
    }

    @Override
    public boolean hasCheckdigit() {
        return true;
    }

    protected int calcCheckdigitFor(String string) {
        int n;
        if (string.length() != 7) {
            return -4;
        }
        int n2 = 0;
        try {
            n2 += 3 * Integer.parseInt(string.substring(0, 1));
            n2 += 7 * Integer.parseInt(string.substring(1, 2));
            n2 += 9 * Integer.parseInt(string.substring(2, 3));
            n2 += 11 * Integer.parseInt(string.substring(3, 4));
            n2 += 13 * Integer.parseInt(string.substring(4, 5));
            n2 += 17 * Integer.parseInt(string.substring(5, 6));
            n = (n2 += 19 * Integer.parseInt(string.substring(6, 7))) % 10;
        }
        catch (NumberFormatException numberFormatException) {
            return -11;
        }
        return n;
    }
}

