/*
 * Decompiled with CFR 0.152.
 */
package HitUpros;

import HitUpros.LomEU;
import HitUpros.LomNumber;
import java.math.BigInteger;
import java.sql.Date;

public final class Lom_UK
extends LomEU {
    private static String[] saHerdNumbers = new String[]{"AA", "AB", "AD", "AG", "AJ", "AN", "AO", "AP", "AR", "AU", "AV", "AW", "AY", "BA", "BB", "BE", "BF", "BK", "BO", "BP", "BS", "BT", "CA", "CE", "CF", "CG", "CL", "CS", "DA", "DB", "DC", "DD", "DE", "DF", "DL", "DM", "DN", "DO", "DP", "DR", "DU", "EA", "EB", "EC", "EF", "EG", "EH", "EJ", "EK", "EL", "EM", "FA", "FF", "FN", "FO", "FP", "FS", "FT", "FU", "FV", "FY", "GA", "GF", "GG", "GH", "GJ", "GL", "GM", "GS", "GW", "HA", "HB", "HC", "HD", "HE", "HK", "HL", "HM", "HN", "HS", "HW", "IE", "IN", "IP", "IV", "IW", "IX", "JA", "JB", "JC", "KA", "KE", "KF", "KG", "KH", "KJ", "KL", "KN", "KO", "KP", "KS", "KT", "KU", "KV", "KW", "LA", "LD", "LE", "LF", "LH", "LJ", "LK", "LL", "LM", "LP", "LQ", "LR", "LS", "LT", "MA", "ME", "MG", "MH", "MJ", "MK", "ML", "MO", "MP", "MQ", "NA", "NC", "ND", "NE", "NG", "NJ", "NK", "NL", "NM", "NN", "NO", "NP", "NQ", "NR", "NS", "NW", "NX", "NZ", "OA", "OB", "OC", "OD", "OE", "OF", "OG", "OH", "OJ", "OK", "OL", "OM", "ON", "OO", "OP", "OQ", "OR", "OS", "OT", "OU", "OV", "OW", "OX", "OZ", "PA", "PE", "QA", "QB", "QC", "QD", "QE", "QF", "QG", "QH", "QJ", "RA", "RB", "RC", "RD", "RO", "RQ", "SB", "SC", "SE", "SG", "SH", "SJ", "SK", "SL", "SM", "SO", "SP", "SQ", "SR", "SS", "ST", "SU", "SV", "SW", "SX", "SY", "SZ", "TA", "TC", "TD", "TE", "TF", "TG", "TH", "TJ", "TK", "UA", "UB", "UC", "VA", "VB", "VC", "VD", "VE", "VF", "VG", "VH", "VJ", "VK", "VL", "VM", "VN", "VP", "WC", "WD", "WE", "WG", "WL", "WO", "WP", "WQ", "WR", "WT", "WU", "XA", "YA", "YB", "YC", "YD", "YE", "YG", "YH", "YJ", "YK", "YL", "YM", "YN", "YO", "YP", "YQ", "YR", "YS", "YT", "YU", "YV", "YW", "YX", "YY", "YZ", "ZA", "ZB", "ZC", "ZD", "ZE", "ZF", "ZG", "ZN", "ZO", "ZP", "ZQ", "ZR", "ZS", "ZT", "A", "B", "C", "D", "E", "F", "G", "H", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    public Lom_UK() {
        this.setCountryParameters("UK", 826, 92);
    }

    @Override
    public int isCountryEU(Date date) {
        return 1;
    }

    @Override
    protected int encodeLomDigits(String string, LomNumber lomNumber, Date date) {
        return this.encodeAlphaLom(string, lomNumber);
    }

    @Override
    protected String decodeLomDigits(LomNumber lomNumber) {
        String string = Lom_UK.sstrToString(lomNumber);
        int n = Integer.parseInt(string.substring(0, 2));
        String string2 = string.substring(2);
        if (n == this.getCountryHIT()) {
            String string3 = this.decodeAlphaLom(string2);
            if (string3 == null) {
                return "#" + Lom_UK.sstrToString(lomNumber);
            }
            return string3;
        }
        string2 = string.substring(3);
        return this.getCountryId() + " " + string2.substring(0, 6) + " " + string2.substring(6, 7) + " " + string2.substring(7, 12);
    }

    @Override
    public boolean hasCheckdigit() {
        return true;
    }

    private int encodeAlphaLom(String string, LomNumber lomNumber) {
        String string2;
        int n = 0;
        if (Character.isLetter(string.charAt(0))) {
            if (string.length() == 8) {
                return -9;
            }
            if (string.length() == 10) {
                n = Lom_UK.getHerdNumber(string.substring(0, 1));
            } else if (string.length() == 11) {
                n = Lom_UK.getHerdNumber(string.substring(0, 2));
            } else {
                return -9;
            }
            if (n < 0) {
                return n;
            }
            try {
                Long.parseLong(string.substring(string.length() - 9));
            }
            catch (NumberFormatException numberFormatException) {
                return -9;
            }
            String string3 = new String("00" + n);
            string3 = string3.substring(string3.length() - 3);
            string2 = this.getCountryHIT() + "0" + string3 + string.substring(string.length() - 9);
        } else {
            if (string.length() == 10) {
                return -9;
            }
            if (string.length() == 12) {
                try {
                    Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return -9;
                }
                string2 = this.getCountryCode() + string;
            } else {
                char c = string.charAt(string.length() - 1);
                int n2 = c - 48;
                if (Character.isLetter(c)) {
                    n2 = 10 + c - 65;
                }
                try {
                    Long.parseLong(string.substring(0, string.length() - 1));
                }
                catch (NumberFormatException numberFormatException) {
                    return -9;
                }
                String string4 = new String("00" + n2);
                string4 = string4.substring(string4.length() - 2);
                string2 = "00000" + string.substring(0, string.length() - 1) + string4;
                string2 = this.getCountryHIT() + (string.length() <= 8 ? "1" : "2") + string2.substring(string2.length() - 12);
            }
        }
        lomNumber.set(new BigInteger(string2));
        return 0;
    }

    private String decodeAlphaLom(String string) {
        int n = Integer.parseInt(string.substring(0, 1));
        if (n == 0) {
            return this.getCountryId() + " " + Lom_UK.getHerdNumber(Integer.parseInt(string.substring(1, 4))) + " " + string.substring(4, 8) + " " + string.substring(8, 13);
        }
        int n2 = Integer.parseInt(string.substring(string.length() - 2));
        char c = n2 < 10 ? (char)(n2 + 48) : (char)(n2 + 65 - 10);
        switch (n) {
            case 1: {
                return this.getCountryId() + " " + string.substring(4, 8) + " " + string.substring(8, 11) + "-" + c;
            }
            case 2: {
                return this.getCountryId() + " " + string.substring(1, 6) + " " + string.substring(6, 11) + "-" + c;
            }
        }
        return null;
    }

    private static int getHerdNumber(String string) {
        for (int i = 0; i < saHerdNumbers.length; ++i) {
            if (!saHerdNumbers[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        return -12;
    }

    private static String getHerdNumber(int n) {
        if (0 <= n && n < saHerdNumbers.length) {
            return saHerdNumbers[n];
        }
        return null;
    }
}

